/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.compare;

import java.util.StringTokenizer;

public class SequenceCompare {
    private SequenceCompare() {
    }

    public static int compareNullLast(String sequence1, String sequence2) {
        if (sequence1 == null && sequence2 == null) {
            return 0;
        }
        if (sequence1 == null && sequence2 != null) {
            return 1;
        }
        if (sequence1 != null && sequence2 == null) {
            return -1;
        }
        String[] components1 = SequenceCompare.componentsFor(sequence1);
        String[] components2 = SequenceCompare.componentsFor(sequence2);
        int length1 = components1.length;
        int length2 = components2.length;
        if (length1 == 0 && length2 == 0) {
            return 0;
        }
        int n = 0;
        int length;
        while (length1 >= (length = n + 1) || length2 < length) {
            if (length2 < length && length1 >= length) {
                return 1;
            }
            if (length1 < length && length2 < length) {
                return 0;
            }
            int componentCompare = 0;
            try {
                Integer c1 = Integer.valueOf(components1[n]);
                Integer c2 = Integer.valueOf(components2[n]);
                componentCompare = c1.compareTo(c2);
            }
            catch (NumberFormatException nfe) {
                componentCompare = components1[n].compareTo(components2[n]);
            }
            if (componentCompare != 0) {
                return componentCompare;
            }
            ++n;
        }
        return -1;
    }

    private static String[] componentsFor(String sequence) {
        StringTokenizer tokens = new StringTokenizer(sequence, ".", false);
        String[] components = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            components[i] = tokens.nextToken();
            ++i;
        }
        return components;
    }
}

