/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.common.v2;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="valueType")
@XmlEnum
public enum ValueType {
    VOID("void"),
    STRING("string"),
    BYTE("byte"),
    SHORT("short"),
    INT("int"),
    LONG("long"),
    FLOAT("float"),
    DOUBLE("double"),
    BOOLEAN("boolean"),
    CHAR("char"),
    BIG_INTEGER("bigInteger"),
    BIG_DECIMAL("bigDecimal"),
    LOCAL_DATE_TIME("localDateTime"),
    LOCAL_DATE("localDate"),
    LOCAL_TIME("localTime"),
    OFFSET_DATE_TIME("offsetDateTime"),
    OFFSET_TIME("offsetTime"),
    ZONED_DATE_TIME("zonedDateTime"),
    ENUM("enum"),
    REFERENCE("reference"),
    COLLECTION("collection"),
    COMPOSITE("composite"),
    BLOB("blob"),
    CLOB("clob");

    private final String value;

    private ValueType(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static ValueType fromValue(String v) {
        for (ValueType c : ValueType.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }
}

