/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value.semantics;

import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.bookmark.IdStringifier;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.applib.value.semantics.Converter;
import org.apache.isis.applib.value.semantics.DefaultsProvider;
import org.apache.isis.applib.value.semantics.OrderRelation;
import org.apache.isis.applib.value.semantics.Parser;
import org.apache.isis.applib.value.semantics.Renderer;
import org.apache.isis.applib.value.semantics.ValueDecomposition;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.schema.common.v2.ValueType;
import org.springframework.lang.Nullable;

public interface ValueSemanticsProvider<T> {
    public Class<T> getCorrespondingClass();

    public ValueType getSchemaValueType();

    public ValueDecomposition decompose(T var1);

    public T compose(ValueDecomposition var1);

    public OrderRelation<T, ?> getOrderRelation();

    public Converter<T, ?> getConverter();

    public Renderer<T> getRenderer();

    public Parser<T> getParser();

    public DefaultsProvider<T> getDefaultsProvider();

    public IdStringifier<T> getIdStringifier();

    default public <X> ValueSemanticsProvider<X> castTo(Class<X> cls) {
        return (ValueSemanticsProvider)_Casts.uncheckedCast((Object)this);
    }

    default public boolean isEnumType() {
        return this.getSchemaValueType() == ValueType.ENUM;
    }

    default public boolean isNumberType() {
        return this.getSchemaValueType() == ValueType.BIG_DECIMAL || this.getSchemaValueType() == ValueType.BIG_INTEGER || this.getSchemaValueType() == ValueType.LONG || this.getSchemaValueType() == ValueType.INT || this.getSchemaValueType() == ValueType.SHORT || this.getSchemaValueType() == ValueType.BYTE || this.getSchemaValueType() == ValueType.DOUBLE || this.getSchemaValueType() == ValueType.FLOAT;
    }

    default public boolean isTemporalType() {
        return this.getSchemaValueType().name().contains("DATE") || this.getSchemaValueType().name().contains("TIME");
    }

    default public boolean isCompositeType() {
        return this.getSchemaValueType() == ValueType.COMPOSITE;
    }

    public static final class Context {
        @Nullable
        private final Identifier featureIdentifier;
        @Nullable
        private final InteractionContext interactionContext;

        private Context(@Nullable Identifier featureIdentifier, @Nullable InteractionContext interactionContext) {
            this.featureIdentifier = featureIdentifier;
            this.interactionContext = interactionContext;
        }

        public static Context of(@Nullable Identifier featureIdentifier, @Nullable InteractionContext interactionContext) {
            return new Context(featureIdentifier, interactionContext);
        }

        @Nullable
        public Identifier getFeatureIdentifier() {
            return this.featureIdentifier;
        }

        @Nullable
        public InteractionContext getInteractionContext() {
            return this.interactionContext;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            Identifier this$featureIdentifier = this.getFeatureIdentifier();
            Identifier other$featureIdentifier = other.getFeatureIdentifier();
            if (this$featureIdentifier == null ? other$featureIdentifier != null : !((Object)this$featureIdentifier).equals(other$featureIdentifier)) {
                return false;
            }
            InteractionContext this$interactionContext = this.getInteractionContext();
            InteractionContext other$interactionContext = other.getInteractionContext();
            return !(this$interactionContext == null ? other$interactionContext != null : !((Object)this$interactionContext).equals(other$interactionContext));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Identifier $featureIdentifier = this.getFeatureIdentifier();
            result = result * 59 + ($featureIdentifier == null ? 43 : ((Object)$featureIdentifier).hashCode());
            InteractionContext $interactionContext = this.getInteractionContext();
            result = result * 59 + ($interactionContext == null ? 43 : ((Object)$interactionContext).hashCode());
            return result;
        }

        public String toString() {
            return "ValueSemanticsProvider.Context(featureIdentifier=" + this.getFeatureIdentifier() + ", interactionContext=" + this.getInteractionContext() + ")";
        }
    }
}

