/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value.semantics;

import lombok.NonNull;
import org.apache.isis.applib.services.bookmark.IdStringifier;
import org.apache.isis.applib.value.semantics.Parser;
import org.apache.isis.applib.value.semantics.Renderer;
import org.apache.isis.applib.value.semantics.ValueDecomposition;
import org.apache.isis.applib.value.semantics.ValueSemanticsAbstract;
import org.apache.isis.applib.value.semantics.ValueSemanticsProvider;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.schema.common.v2.ValueType;

public abstract class ValueSemanticsBasedOnIdStringifierEntityAgnostic<T>
extends ValueSemanticsAbstract<T>
implements Renderer<T>,
Parser<T>,
IdStringifier.EntityAgnostic<T> {
    private final Class<T> correspondingClass;

    protected ValueSemanticsBasedOnIdStringifierEntityAgnostic(@NonNull Class<T> correspondingClass) {
        if (correspondingClass == null) {
            throw new NullPointerException("correspondingClass is marked non-null but is null");
        }
        _Assert.assertFalse((boolean)correspondingClass.isPrimitive(), () -> String.format("not allowed to be initialized with a primitive class (%s), use the boxed variant instead", correspondingClass));
        this.correspondingClass = correspondingClass;
    }

    @Override
    public final ValueType getSchemaValueType() {
        return ValueType.STRING;
    }

    @Override
    public String enstring(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return value.toString();
    }

    @Override
    public final ValueDecomposition decompose(T value) {
        return this.decomposeAsString(value, this::enstring, () -> null);
    }

    @Override
    public final T compose(ValueDecomposition decomposition) {
        return (T)this.composeFromString(decomposition, this::destring, () -> null);
    }

    @Override
    public String titlePresentation(ValueSemanticsProvider.Context context, T value) {
        return value == null ? "" : this.enstring(value);
    }

    @Override
    public String parseableTextRepresentation(ValueSemanticsProvider.Context context, T value) {
        return this.enstring(value);
    }

    @Override
    public T parseTextRepresentation(ValueSemanticsProvider.Context context, String text) {
        return this.destring(text);
    }

    @Override
    public int typicalLength() {
        return 255;
    }

    @Override
    public final Class<T> getCorrespondingClass() {
        return this.correspondingClass;
    }
}

