/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value.semantics;

import lombok.NonNull;
import org.apache.isis.applib.services.bookmark.IdStringifier;
import org.apache.isis.applib.value.semantics.ValueSemanticsAbstract;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.schema.common.v2.ValueType;

public abstract class ValueSemanticsBasedOnIdStringifier<T>
extends ValueSemanticsAbstract<T>
implements IdStringifier<T> {
    private final Class<T> correspondingClass;

    protected ValueSemanticsBasedOnIdStringifier(@NonNull Class<T> correspondingClass) {
        if (correspondingClass == null) {
            throw new NullPointerException("correspondingClass is marked non-null but is null");
        }
        _Assert.assertFalse((boolean)correspondingClass.isPrimitive(), () -> String.format("not allowed to be initialzed with a primitive class (%s), use the boxed variant instead", correspondingClass));
        this.correspondingClass = correspondingClass;
    }

    @Override
    public final ValueType getSchemaValueType() {
        return ValueType.STRING;
    }

    @Override
    public String enstring(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return value.toString();
    }

    @Override
    public final Class<T> getCorrespondingClass() {
        return this.correspondingClass;
    }
}

