/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value.semantics;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.isis.applib.annotation.TimePrecision;
import org.apache.isis.applib.exceptions.recoverable.TextEntryParseException;
import org.apache.isis.applib.locale.UserLocale;
import org.apache.isis.applib.services.bookmark.IdStringifier;
import org.apache.isis.applib.services.i18n.TranslationContext;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.applib.services.placeholder.PlaceholderRenderService;
import org.apache.isis.applib.util.schema.CommonDtoUtils;
import org.apache.isis.applib.value.semantics.Converter;
import org.apache.isis.applib.value.semantics.DefaultsProvider;
import org.apache.isis.applib.value.semantics.OrderRelation;
import org.apache.isis.applib.value.semantics.Parser;
import org.apache.isis.applib.value.semantics.Renderer;
import org.apache.isis.applib.value.semantics.TemporalValueSemantics;
import org.apache.isis.applib.value.semantics.ValueDecomposition;
import org.apache.isis.applib.value.semantics.ValueSemanticsProvider;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.base._Temporals;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.schema.common.v2.ValueDto;
import org.apache.isis.schema.common.v2.ValueType;
import org.apache.isis.schema.common.v2.ValueWithTypeDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;

public abstract class ValueSemanticsAbstract<T>
implements ValueSemanticsProvider<T> {
    @Autowired(required=false)
    protected TranslationService translationService;
    @Autowired(required=false)
    private Optional<PlaceholderRenderService> placeholderRenderService = Optional.empty();

    @Override
    public OrderRelation<T, ?> getOrderRelation() {
        return this instanceof OrderRelation ? (OrderRelation)((Object)this) : null;
    }

    @Override
    public Converter<T, ?> getConverter() {
        return this instanceof Converter ? (Converter)((Object)this) : null;
    }

    @Override
    public Renderer<T> getRenderer() {
        return this instanceof Renderer ? (Renderer)((Object)this) : null;
    }

    @Override
    public Parser<T> getParser() {
        return this instanceof Parser ? (Parser)((Object)this) : null;
    }

    @Override
    public DefaultsProvider<T> getDefaultsProvider() {
        return this instanceof DefaultsProvider ? (DefaultsProvider)((Object)this) : null;
    }

    @Override
    public IdStringifier<T> getIdStringifier() {
        return this instanceof IdStringifier ? (IdStringifier)((Object)this) : null;
    }

    public Can<T> getExamples() {
        return Can.empty();
    }

    protected UserLocale getUserLocale(@Nullable ValueSemanticsProvider.Context context) {
        return Optional.ofNullable(context).map(ValueSemanticsProvider.Context::getInteractionContext).map(InteractionContext::getLocale).orElseGet(UserLocale::getDefault);
    }

    protected String renderTitle(T value, Function<T, String> toString) {
        return Optional.ofNullable(value).map(toString).orElseGet(() -> this.getPlaceholderRenderService().asText(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
    }

    protected String renderHtml(T value, Function<T, String> toString) {
        return Optional.ofNullable(value).map(toString).orElseGet(() -> this.getPlaceholderRenderService().asHtml(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
    }

    protected ValueDecomposition decomposeAsString(@Nullable T value, @NonNull Function<T, String> toString, @NonNull Supplier<String> onNull) {
        if (toString == null) {
            throw new NullPointerException("toString is marked non-null but is null");
        }
        if (onNull == null) {
            throw new NullPointerException("onNull is marked non-null but is null");
        }
        _Assert.assertEquals((Object)this.getSchemaValueType(), (Object)ValueType.STRING);
        return CommonDtoUtils.fundamentalTypeAsDecomposition(ValueType.STRING, value != null ? toString.apply(value) : onNull.get());
    }

    protected T composeFromString(@Nullable ValueDecomposition decomposition, @NonNull Function<String, T> fromString, @NonNull Supplier<T> onNullOrEmpty) {
        if (fromString == null) {
            throw new NullPointerException("fromString is marked non-null but is null");
        }
        if (onNullOrEmpty == null) {
            throw new NullPointerException("onNullOrEmpty is marked non-null but is null");
        }
        String string = decomposition != null ? (String)decomposition.left().map(ValueDto::getString).orElse(null) : null;
        return _Strings.isNotEmpty(string) ? fromString.apply(string) : onNullOrEmpty.get();
    }

    protected <F> ValueDecomposition decomposeAsNullable(@Nullable T value, @NonNull Function<T, F> onNonNull, @NonNull Supplier<F> onNull) {
        if (onNonNull == null) {
            throw new NullPointerException("onNonNull is marked non-null but is null");
        }
        if (onNull == null) {
            throw new NullPointerException("onNull is marked non-null but is null");
        }
        return CommonDtoUtils.fundamentalTypeAsDecomposition(this.getSchemaValueType(), value != null ? onNonNull.apply(value) : onNull.get());
    }

    protected <F> T composeFromNullable(@Nullable ValueDecomposition decomposition, @NonNull Function<ValueWithTypeDto, F> fundamentalValueExtractor, @NonNull Function<F, T> onNonNull, @NonNull Supplier<T> onNull) {
        if (fundamentalValueExtractor == null) {
            throw new NullPointerException("fundamentalValueExtractor is marked non-null but is null");
        }
        if (onNonNull == null) {
            throw new NullPointerException("onNonNull is marked non-null but is null");
        }
        if (onNull == null) {
            throw new NullPointerException("onNull is marked non-null but is null");
        }
        Object valuePojo = decomposition != null ? decomposition.left().map(fundamentalValueExtractor).orElse(null) : null;
        return valuePojo != null ? onNonNull.apply(valuePojo) : onNull.get();
    }

    protected DecimalFormat getNumberFormat(@Nullable ValueSemanticsProvider.Context context) {
        return this.getNumberFormat(context, FormatUsageFor.RENDERING);
    }

    protected DecimalFormat getNumberFormat(@Nullable ValueSemanticsProvider.Context context, @NonNull FormatUsageFor usedFor) {
        if (usedFor == null) {
            throw new NullPointerException("usedFor is marked non-null but is null");
        }
        DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(this.getUserLocale(context).getNumberFormatLocale());
        format.setMaximumFractionDigits(16);
        this.configureDecimalFormat(context, format, usedFor);
        return format;
    }

    protected Optional<BigInteger> parseInteger(@Nullable ValueSemanticsProvider.Context context, @Nullable String text) {
        String input = _Strings.blankToNullOrTrim((String)text);
        if (input == null) {
            return Optional.empty();
        }
        try {
            return this.parseDecimal(context, input).map(BigDecimal::toBigIntegerExact);
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new TextEntryParseException("Not an integer value " + text, e);
        }
    }

    protected Optional<BigDecimal> parseDecimal(@Nullable ValueSemanticsProvider.Context context, @Nullable String text) {
        String input = _Strings.blankToNullOrTrim((String)text);
        if (input == null) {
            return Optional.empty();
        }
        DecimalFormat format = this.getNumberFormat(context, FormatUsageFor.PARSING);
        format.setParseBigDecimal(true);
        ParsePosition position = new ParsePosition(0);
        try {
            BigDecimal number = (BigDecimal)format.parse(input, position);
            if (position.getErrorIndex() != -1) {
                throw new ParseException("could not parse input='" + input + "'", position.getErrorIndex());
            }
            if (position.getIndex() < input.length()) {
                throw new ParseException("input='" + input + "' was not processed completely", position.getIndex());
            }
            int maxFractionDigits = format.getMaximumFractionDigits();
            if (maxFractionDigits > -1 && number.scale() > format.getMaximumFractionDigits()) {
                throw new TextEntryParseException(String.format("No more than %d digits can be entered after the decimal separator, got %d in '%s'.", maxFractionDigits, number.scale(), input));
            }
            return Optional.of(number);
        }
        catch (NumberFormatException | ParseException e) {
            throw new TextEntryParseException(String.format("Not a decimal value '%s': %s", input, e.getMessage()), e);
        }
    }

    protected void configureDecimalFormat(ValueSemanticsProvider.Context context, DecimalFormat format, FormatUsageFor usedFor) {
    }

    protected DateTimeFormatter getTemporalNoZoneRenderingFormat(@Nullable ValueSemanticsProvider.Context context, @NonNull TemporalValueSemantics.TemporalCharacteristic temporalCharacteristic, @NonNull TemporalValueSemantics.OffsetCharacteristic offsetCharacteristic, @NonNull FormatStyle dateFormatStyle, @NonNull FormatStyle timeFormatStyle) {
        DateTimeFormatter noZoneOutputFormat;
        if (temporalCharacteristic == null) {
            throw new NullPointerException("temporalCharacteristic is marked non-null but is null");
        }
        if (offsetCharacteristic == null) {
            throw new NullPointerException("offsetCharacteristic is marked non-null but is null");
        }
        if (dateFormatStyle == null) {
            throw new NullPointerException("dateFormatStyle is marked non-null but is null");
        }
        if (timeFormatStyle == null) {
            throw new NullPointerException("timeFormatStyle is marked non-null but is null");
        }
        switch (temporalCharacteristic) {
            case DATE_TIME: {
                noZoneOutputFormat = DateTimeFormatter.ofLocalizedDateTime(dateFormatStyle, timeFormatStyle);
                break;
            }
            case DATE_ONLY: {
                noZoneOutputFormat = DateTimeFormatter.ofLocalizedDate(dateFormatStyle);
                break;
            }
            case TIME_ONLY: {
                noZoneOutputFormat = DateTimeFormatter.ofLocalizedTime(timeFormatStyle);
                break;
            }
            default: {
                throw _Exceptions.unmatchedCase((Object)((Object)temporalCharacteristic));
            }
        }
        return noZoneOutputFormat.withLocale(this.getUserLocale(context).getTimeFormatLocale());
    }

    protected Optional<DateTimeFormatter> getTemporalZoneOnlyRenderingFormat(@Nullable ValueSemanticsProvider.Context context, @NonNull TemporalValueSemantics.TemporalCharacteristic temporalCharacteristic, @NonNull TemporalValueSemantics.OffsetCharacteristic offsetCharacteristic) {
        if (temporalCharacteristic == null) {
            throw new NullPointerException("temporalCharacteristic is marked non-null but is null");
        }
        if (offsetCharacteristic == null) {
            throw new NullPointerException("offsetCharacteristic is marked non-null but is null");
        }
        switch (offsetCharacteristic) {
            case LOCAL: {
                return Optional.empty();
            }
            case OFFSET: {
                return Optional.of(_Temporals.ISO_OFFSET_ONLY_FORMAT);
            }
            case ZONED: {
                return Optional.of(_Temporals.DEFAULT_ZONEID_ONLY_FORMAT);
            }
        }
        throw _Exceptions.unmatchedCase((Object)((Object)offsetCharacteristic));
    }

    protected DateTimeFormatter getTemporalEditingFormat(@Nullable ValueSemanticsProvider.Context context, @NonNull TemporalValueSemantics.TemporalCharacteristic temporalCharacteristic, @NonNull TemporalValueSemantics.OffsetCharacteristic offsetCharacteristic, @NonNull TimePrecision timePrecision, @NonNull TemporalValueSemantics.EditingFormatDirection direction, @NonNull TemporalValueSemantics.TemporalEditingPattern editingPattern) {
        if (temporalCharacteristic == null) {
            throw new NullPointerException("temporalCharacteristic is marked non-null but is null");
        }
        if (offsetCharacteristic == null) {
            throw new NullPointerException("offsetCharacteristic is marked non-null but is null");
        }
        if (timePrecision == null) {
            throw new NullPointerException("timePrecision is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        if (editingPattern == null) {
            throw new NullPointerException("editingPattern is marked non-null but is null");
        }
        return new DateTimeFormatterBuilder().appendPattern(editingPattern.getEditingFormatAsPattern(temporalCharacteristic, offsetCharacteristic, timePrecision, direction)).toFormatter(this.getUserLocale(context).getTimeFormatLocale());
    }

    protected DateTimeFormatter getTemporalIsoFormat(@NonNull TemporalValueSemantics.TemporalCharacteristic temporalCharacteristic, @NonNull TemporalValueSemantics.OffsetCharacteristic offsetCharacteristic) {
        if (temporalCharacteristic == null) {
            throw new NullPointerException("temporalCharacteristic is marked non-null but is null");
        }
        if (offsetCharacteristic == null) {
            throw new NullPointerException("offsetCharacteristic is marked non-null but is null");
        }
        switch (temporalCharacteristic) {
            case DATE_TIME: {
                return offsetCharacteristic.isLocal() ? DateTimeFormatter.ISO_LOCAL_DATE_TIME : DateTimeFormatter.ISO_DATE_TIME;
            }
            case DATE_ONLY: {
                return offsetCharacteristic.isLocal() ? DateTimeFormatter.ISO_LOCAL_DATE : DateTimeFormatter.ISO_DATE;
            }
            case TIME_ONLY: {
                return offsetCharacteristic.isLocal() ? DateTimeFormatter.ISO_LOCAL_TIME : DateTimeFormatter.ISO_TIME;
            }
        }
        throw _Exceptions.unmatchedCase((Object)((Object)temporalCharacteristic));
    }

    protected String translate(String text) {
        return this.translationService != null ? this.translationService.translate(TranslationContext.empty(), text) : text;
    }

    protected PlaceholderRenderService getPlaceholderRenderService() {
        return this.placeholderRenderService.orElseGet(PlaceholderRenderService::fallback);
    }

    protected static enum FormatUsageFor {
        PARSING,
        RENDERING;


        public boolean isParsing() {
            return this == PARSING;
        }

        public boolean isRendering() {
            return this == RENDERING;
        }
    }
}

