/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value.semantics;

import java.io.Serializable;
import org.apache.isis.applib.util.schema.CommonDtoUtils;
import org.apache.isis.commons.functional.Either;
import org.apache.isis.schema.common.v2.TypedTupleDto;
import org.apache.isis.schema.common.v2.ValueType;
import org.apache.isis.schema.common.v2.ValueWithTypeDto;

public final class ValueDecomposition
implements Either.HasEither<ValueWithTypeDto, TypedTupleDto>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Either<ValueWithTypeDto, TypedTupleDto> either;

    public static ValueDecomposition ofFundamental(ValueWithTypeDto valueWithTypeDto) {
        return new ValueDecomposition((Either<ValueWithTypeDto, TypedTupleDto>)Either.left((Object)valueWithTypeDto));
    }

    public static ValueDecomposition ofComposite(TypedTupleDto typedTupleDto) {
        return new ValueDecomposition((Either<ValueWithTypeDto, TypedTupleDto>)Either.right((Object)typedTupleDto));
    }

    @Deprecated
    public ValueDecomposition() {
        this((Either<ValueWithTypeDto, TypedTupleDto>)Either.left((Object)new ValueWithTypeDto()));
    }

    public String toJson() {
        return (String)this.fold(CommonDtoUtils::getFundamentalValueAsJson, CommonDtoUtils::getCompositeValueAsJson);
    }

    public static ValueDecomposition fromJson(ValueType vType, String json) {
        return vType == ValueType.COMPOSITE ? ValueDecomposition.ofComposite(CommonDtoUtils.getCompositeValueFromJson(json)) : ValueDecomposition.ofFundamental(CommonDtoUtils.getFundamentalValueFromJson(vType, json));
    }

    protected ValueDecomposition(Either<ValueWithTypeDto, TypedTupleDto> either) {
        this.either = either;
    }

    public String toString() {
        return "ValueDecomposition(either=" + this.getEither() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueDecomposition)) {
            return false;
        }
        ValueDecomposition other = (ValueDecomposition)o;
        Either<ValueWithTypeDto, TypedTupleDto> this$either = this.getEither();
        Either<ValueWithTypeDto, TypedTupleDto> other$either = other.getEither();
        return !(this$either == null ? other$either != null : !this$either.equals(other$either));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Either<ValueWithTypeDto, TypedTupleDto> $either = this.getEither();
        result = result * 59 + ($either == null ? 43 : $either.hashCode());
        return result;
    }

    public Either<ValueWithTypeDto, TypedTupleDto> getEither() {
        return this.either;
    }
}

