/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value.semantics;

import java.time.Duration;
import java.time.temporal.Temporal;
import lombok.NonNull;
import org.apache.isis.applib.annotation.TimePrecision;
import org.apache.isis.applib.value.semantics.OrderRelation;
import org.apache.isis.applib.value.semantics.Parser;
import org.apache.isis.applib.value.semantics.Renderer;
import org.apache.isis.commons.internal.exceptions._Exceptions;

public interface TemporalValueSemantics<T extends Temporal>
extends OrderRelation<T, Duration>,
Parser<T>,
Renderer<T> {
    public TemporalCharacteristic getTemporalCharacteristic();

    public OffsetCharacteristic getOffsetCharacteristic();

    public static class TemporalEditingPattern {
        @NonNull
        private String datePattern = "yyyy-MM-dd";
        @NonNull
        private String timePatternNanoSecond = "HH[:mm[:ss][.SSSSSSSSS]]";
        @NonNull
        private String timePatternMicroSecond = "HH[:mm[:ss][.SSSSSS]]";
        @NonNull
        private String timePatternMilliSecond = "HH[:mm[:ss][.SSS]]";
        @NonNull
        private String timePatternSecond = "HH[:mm[:ss]]";
        @NonNull
        private String timePatternMinute = "HH[:mm]";
        @NonNull
        private String timePatternHour = "HH";
        @NonNull
        private String zoneIdPatternForOutput = "VV";
        @NonNull
        private String zoneIdPatternForInput = "VV";
        @NonNull
        private String offsetPatternForOutput = "XXX";
        @NonNull
        private String offsetPatternForInput = "[XXX][X]";
        @NonNull
        private String dateTimeJoiningPattern = "%1$s %2$s";
        @NonNull
        private String zoneJoiningPattern = "%1$s %2$s";

        public String getEditingFormatAsPattern(@NonNull TemporalCharacteristic temporalCharacteristic, @NonNull OffsetCharacteristic offsetCharacteristic, @NonNull TimePrecision timePrecision, @NonNull EditingFormatDirection direction) {
            if (temporalCharacteristic == null) {
                throw new NullPointerException("temporalCharacteristic is marked non-null but is null");
            }
            if (offsetCharacteristic == null) {
                throw new NullPointerException("offsetCharacteristic is marked non-null but is null");
            }
            if (timePrecision == null) {
                throw new NullPointerException("timePrecision is marked non-null but is null");
            }
            if (direction == null) {
                throw new NullPointerException("direction is marked non-null but is null");
            }
            switch (temporalCharacteristic) {
                case DATE_TIME: {
                    String dateTimePattern = String.format(this.getDateTimeJoiningPattern(), this.getDatePattern(), this.timePattern(timePrecision, direction));
                    return offsetCharacteristic.isLocal() ? dateTimePattern : String.format(this.getZoneJoiningPattern(), dateTimePattern, this.zonePattern(offsetCharacteristic, direction));
                }
                case DATE_ONLY: {
                    return offsetCharacteristic.isLocal() ? this.getDatePattern() : String.format(this.getZoneJoiningPattern(), this.getDatePattern(), this.zonePattern(offsetCharacteristic, direction));
                }
                case TIME_ONLY: {
                    return offsetCharacteristic.isLocal() ? this.timePattern(timePrecision, direction) : String.format(this.getZoneJoiningPattern(), this.timePattern(timePrecision, direction), this.zonePattern(offsetCharacteristic, direction));
                }
            }
            throw _Exceptions.unmatchedCase((Object)((Object)temporalCharacteristic));
        }

        private String zonePattern(@NonNull OffsetCharacteristic offsetCharacteristic, @NonNull EditingFormatDirection direction) {
            if (offsetCharacteristic == null) {
                throw new NullPointerException("offsetCharacteristic is marked non-null but is null");
            }
            if (direction == null) {
                throw new NullPointerException("direction is marked non-null but is null");
            }
            switch (offsetCharacteristic) {
                case OFFSET: {
                    return direction.isInput() ? this.getOffsetPatternForInput() : this.getOffsetPatternForOutput();
                }
                case ZONED: {
                    return direction.isInput() ? this.getZoneIdPatternForInput() : this.getZoneIdPatternForOutput();
                }
            }
            throw _Exceptions.unexpectedCodeReach();
        }

        private String timePattern(@NonNull TimePrecision timePrecision, @NonNull EditingFormatDirection direction) {
            if (timePrecision == null) {
                throw new NullPointerException("timePrecision is marked non-null but is null");
            }
            if (direction == null) {
                throw new NullPointerException("direction is marked non-null but is null");
            }
            switch (direction) {
                case INPUT: {
                    return this.timePattern(timePrecision);
                }
                case OUTPUT: {
                    return this.timePattern(timePrecision).replace("[", "").replace("]", "");
                }
            }
            throw _Exceptions.unmatchedCase((Object)((Object)direction));
        }

        private String timePattern(@NonNull TimePrecision timePrecision) {
            if (timePrecision == null) {
                throw new NullPointerException("timePrecision is marked non-null but is null");
            }
            switch (timePrecision) {
                case NANO_SECOND: {
                    return this.getTimePatternNanoSecond();
                }
                case MICRO_SECOND: {
                    return this.getTimePatternMicroSecond();
                }
                case MILLI_SECOND: {
                    return this.getTimePatternMilliSecond();
                }
                case UNSPECIFIED: 
                case SECOND: {
                    return this.getTimePatternSecond();
                }
                case MINUTE: {
                    return this.getTimePatternMinute();
                }
                case HOUR: {
                    return this.getTimePatternHour();
                }
            }
            throw _Exceptions.unmatchedCase((Object)((Object)timePrecision));
        }

        @NonNull
        public String getDatePattern() {
            return this.datePattern;
        }

        @NonNull
        public String getTimePatternNanoSecond() {
            return this.timePatternNanoSecond;
        }

        @NonNull
        public String getTimePatternMicroSecond() {
            return this.timePatternMicroSecond;
        }

        @NonNull
        public String getTimePatternMilliSecond() {
            return this.timePatternMilliSecond;
        }

        @NonNull
        public String getTimePatternSecond() {
            return this.timePatternSecond;
        }

        @NonNull
        public String getTimePatternMinute() {
            return this.timePatternMinute;
        }

        @NonNull
        public String getTimePatternHour() {
            return this.timePatternHour;
        }

        @NonNull
        public String getZoneIdPatternForOutput() {
            return this.zoneIdPatternForOutput;
        }

        @NonNull
        public String getZoneIdPatternForInput() {
            return this.zoneIdPatternForInput;
        }

        @NonNull
        public String getOffsetPatternForOutput() {
            return this.offsetPatternForOutput;
        }

        @NonNull
        public String getOffsetPatternForInput() {
            return this.offsetPatternForInput;
        }

        @NonNull
        public String getDateTimeJoiningPattern() {
            return this.dateTimeJoiningPattern;
        }

        @NonNull
        public String getZoneJoiningPattern() {
            return this.zoneJoiningPattern;
        }

        public void setDatePattern(@NonNull String datePattern) {
            if (datePattern == null) {
                throw new NullPointerException("datePattern is marked non-null but is null");
            }
            this.datePattern = datePattern;
        }

        public void setTimePatternNanoSecond(@NonNull String timePatternNanoSecond) {
            if (timePatternNanoSecond == null) {
                throw new NullPointerException("timePatternNanoSecond is marked non-null but is null");
            }
            this.timePatternNanoSecond = timePatternNanoSecond;
        }

        public void setTimePatternMicroSecond(@NonNull String timePatternMicroSecond) {
            if (timePatternMicroSecond == null) {
                throw new NullPointerException("timePatternMicroSecond is marked non-null but is null");
            }
            this.timePatternMicroSecond = timePatternMicroSecond;
        }

        public void setTimePatternMilliSecond(@NonNull String timePatternMilliSecond) {
            if (timePatternMilliSecond == null) {
                throw new NullPointerException("timePatternMilliSecond is marked non-null but is null");
            }
            this.timePatternMilliSecond = timePatternMilliSecond;
        }

        public void setTimePatternSecond(@NonNull String timePatternSecond) {
            if (timePatternSecond == null) {
                throw new NullPointerException("timePatternSecond is marked non-null but is null");
            }
            this.timePatternSecond = timePatternSecond;
        }

        public void setTimePatternMinute(@NonNull String timePatternMinute) {
            if (timePatternMinute == null) {
                throw new NullPointerException("timePatternMinute is marked non-null but is null");
            }
            this.timePatternMinute = timePatternMinute;
        }

        public void setTimePatternHour(@NonNull String timePatternHour) {
            if (timePatternHour == null) {
                throw new NullPointerException("timePatternHour is marked non-null but is null");
            }
            this.timePatternHour = timePatternHour;
        }

        public void setZoneIdPatternForOutput(@NonNull String zoneIdPatternForOutput) {
            if (zoneIdPatternForOutput == null) {
                throw new NullPointerException("zoneIdPatternForOutput is marked non-null but is null");
            }
            this.zoneIdPatternForOutput = zoneIdPatternForOutput;
        }

        public void setZoneIdPatternForInput(@NonNull String zoneIdPatternForInput) {
            if (zoneIdPatternForInput == null) {
                throw new NullPointerException("zoneIdPatternForInput is marked non-null but is null");
            }
            this.zoneIdPatternForInput = zoneIdPatternForInput;
        }

        public void setOffsetPatternForOutput(@NonNull String offsetPatternForOutput) {
            if (offsetPatternForOutput == null) {
                throw new NullPointerException("offsetPatternForOutput is marked non-null but is null");
            }
            this.offsetPatternForOutput = offsetPatternForOutput;
        }

        public void setOffsetPatternForInput(@NonNull String offsetPatternForInput) {
            if (offsetPatternForInput == null) {
                throw new NullPointerException("offsetPatternForInput is marked non-null but is null");
            }
            this.offsetPatternForInput = offsetPatternForInput;
        }

        public void setDateTimeJoiningPattern(@NonNull String dateTimeJoiningPattern) {
            if (dateTimeJoiningPattern == null) {
                throw new NullPointerException("dateTimeJoiningPattern is marked non-null but is null");
            }
            this.dateTimeJoiningPattern = dateTimeJoiningPattern;
        }

        public void setZoneJoiningPattern(@NonNull String zoneJoiningPattern) {
            if (zoneJoiningPattern == null) {
                throw new NullPointerException("zoneJoiningPattern is marked non-null but is null");
            }
            this.zoneJoiningPattern = zoneJoiningPattern;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemporalEditingPattern)) {
                return false;
            }
            TemporalEditingPattern other = (TemporalEditingPattern)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$datePattern = this.getDatePattern();
            String other$datePattern = other.getDatePattern();
            if (this$datePattern == null ? other$datePattern != null : !this$datePattern.equals(other$datePattern)) {
                return false;
            }
            String this$timePatternNanoSecond = this.getTimePatternNanoSecond();
            String other$timePatternNanoSecond = other.getTimePatternNanoSecond();
            if (this$timePatternNanoSecond == null ? other$timePatternNanoSecond != null : !this$timePatternNanoSecond.equals(other$timePatternNanoSecond)) {
                return false;
            }
            String this$timePatternMicroSecond = this.getTimePatternMicroSecond();
            String other$timePatternMicroSecond = other.getTimePatternMicroSecond();
            if (this$timePatternMicroSecond == null ? other$timePatternMicroSecond != null : !this$timePatternMicroSecond.equals(other$timePatternMicroSecond)) {
                return false;
            }
            String this$timePatternMilliSecond = this.getTimePatternMilliSecond();
            String other$timePatternMilliSecond = other.getTimePatternMilliSecond();
            if (this$timePatternMilliSecond == null ? other$timePatternMilliSecond != null : !this$timePatternMilliSecond.equals(other$timePatternMilliSecond)) {
                return false;
            }
            String this$timePatternSecond = this.getTimePatternSecond();
            String other$timePatternSecond = other.getTimePatternSecond();
            if (this$timePatternSecond == null ? other$timePatternSecond != null : !this$timePatternSecond.equals(other$timePatternSecond)) {
                return false;
            }
            String this$timePatternMinute = this.getTimePatternMinute();
            String other$timePatternMinute = other.getTimePatternMinute();
            if (this$timePatternMinute == null ? other$timePatternMinute != null : !this$timePatternMinute.equals(other$timePatternMinute)) {
                return false;
            }
            String this$timePatternHour = this.getTimePatternHour();
            String other$timePatternHour = other.getTimePatternHour();
            if (this$timePatternHour == null ? other$timePatternHour != null : !this$timePatternHour.equals(other$timePatternHour)) {
                return false;
            }
            String this$zoneIdPatternForOutput = this.getZoneIdPatternForOutput();
            String other$zoneIdPatternForOutput = other.getZoneIdPatternForOutput();
            if (this$zoneIdPatternForOutput == null ? other$zoneIdPatternForOutput != null : !this$zoneIdPatternForOutput.equals(other$zoneIdPatternForOutput)) {
                return false;
            }
            String this$zoneIdPatternForInput = this.getZoneIdPatternForInput();
            String other$zoneIdPatternForInput = other.getZoneIdPatternForInput();
            if (this$zoneIdPatternForInput == null ? other$zoneIdPatternForInput != null : !this$zoneIdPatternForInput.equals(other$zoneIdPatternForInput)) {
                return false;
            }
            String this$offsetPatternForOutput = this.getOffsetPatternForOutput();
            String other$offsetPatternForOutput = other.getOffsetPatternForOutput();
            if (this$offsetPatternForOutput == null ? other$offsetPatternForOutput != null : !this$offsetPatternForOutput.equals(other$offsetPatternForOutput)) {
                return false;
            }
            String this$offsetPatternForInput = this.getOffsetPatternForInput();
            String other$offsetPatternForInput = other.getOffsetPatternForInput();
            if (this$offsetPatternForInput == null ? other$offsetPatternForInput != null : !this$offsetPatternForInput.equals(other$offsetPatternForInput)) {
                return false;
            }
            String this$dateTimeJoiningPattern = this.getDateTimeJoiningPattern();
            String other$dateTimeJoiningPattern = other.getDateTimeJoiningPattern();
            if (this$dateTimeJoiningPattern == null ? other$dateTimeJoiningPattern != null : !this$dateTimeJoiningPattern.equals(other$dateTimeJoiningPattern)) {
                return false;
            }
            String this$zoneJoiningPattern = this.getZoneJoiningPattern();
            String other$zoneJoiningPattern = other.getZoneJoiningPattern();
            return !(this$zoneJoiningPattern == null ? other$zoneJoiningPattern != null : !this$zoneJoiningPattern.equals(other$zoneJoiningPattern));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TemporalEditingPattern;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $datePattern = this.getDatePattern();
            result = result * 59 + ($datePattern == null ? 43 : $datePattern.hashCode());
            String $timePatternNanoSecond = this.getTimePatternNanoSecond();
            result = result * 59 + ($timePatternNanoSecond == null ? 43 : $timePatternNanoSecond.hashCode());
            String $timePatternMicroSecond = this.getTimePatternMicroSecond();
            result = result * 59 + ($timePatternMicroSecond == null ? 43 : $timePatternMicroSecond.hashCode());
            String $timePatternMilliSecond = this.getTimePatternMilliSecond();
            result = result * 59 + ($timePatternMilliSecond == null ? 43 : $timePatternMilliSecond.hashCode());
            String $timePatternSecond = this.getTimePatternSecond();
            result = result * 59 + ($timePatternSecond == null ? 43 : $timePatternSecond.hashCode());
            String $timePatternMinute = this.getTimePatternMinute();
            result = result * 59 + ($timePatternMinute == null ? 43 : $timePatternMinute.hashCode());
            String $timePatternHour = this.getTimePatternHour();
            result = result * 59 + ($timePatternHour == null ? 43 : $timePatternHour.hashCode());
            String $zoneIdPatternForOutput = this.getZoneIdPatternForOutput();
            result = result * 59 + ($zoneIdPatternForOutput == null ? 43 : $zoneIdPatternForOutput.hashCode());
            String $zoneIdPatternForInput = this.getZoneIdPatternForInput();
            result = result * 59 + ($zoneIdPatternForInput == null ? 43 : $zoneIdPatternForInput.hashCode());
            String $offsetPatternForOutput = this.getOffsetPatternForOutput();
            result = result * 59 + ($offsetPatternForOutput == null ? 43 : $offsetPatternForOutput.hashCode());
            String $offsetPatternForInput = this.getOffsetPatternForInput();
            result = result * 59 + ($offsetPatternForInput == null ? 43 : $offsetPatternForInput.hashCode());
            String $dateTimeJoiningPattern = this.getDateTimeJoiningPattern();
            result = result * 59 + ($dateTimeJoiningPattern == null ? 43 : $dateTimeJoiningPattern.hashCode());
            String $zoneJoiningPattern = this.getZoneJoiningPattern();
            result = result * 59 + ($zoneJoiningPattern == null ? 43 : $zoneJoiningPattern.hashCode());
            return result;
        }

        public String toString() {
            return "TemporalValueSemantics.TemporalEditingPattern(datePattern=" + this.getDatePattern() + ", timePatternNanoSecond=" + this.getTimePatternNanoSecond() + ", timePatternMicroSecond=" + this.getTimePatternMicroSecond() + ", timePatternMilliSecond=" + this.getTimePatternMilliSecond() + ", timePatternSecond=" + this.getTimePatternSecond() + ", timePatternMinute=" + this.getTimePatternMinute() + ", timePatternHour=" + this.getTimePatternHour() + ", zoneIdPatternForOutput=" + this.getZoneIdPatternForOutput() + ", zoneIdPatternForInput=" + this.getZoneIdPatternForInput() + ", offsetPatternForOutput=" + this.getOffsetPatternForOutput() + ", offsetPatternForInput=" + this.getOffsetPatternForInput() + ", dateTimeJoiningPattern=" + this.getDateTimeJoiningPattern() + ", zoneJoiningPattern=" + this.getZoneJoiningPattern() + ")";
        }
    }

    public static enum EditingFormatDirection {
        INPUT,
        OUTPUT;


        public boolean isInput() {
            return this == INPUT;
        }

        public boolean isOutput() {
            return this == OUTPUT;
        }
    }

    public static enum OffsetCharacteristic {
        LOCAL,
        OFFSET,
        ZONED;


        public boolean isLocal() {
            return this == LOCAL;
        }

        public boolean isOffset() {
            return this == OFFSET;
        }

        public boolean isZoned() {
            return this == ZONED;
        }
    }

    public static enum TemporalCharacteristic {
        TIME_ONLY,
        DATE_ONLY,
        DATE_TIME;

    }
}

