/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import java.io.Serializable;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Strings;

public interface NamedWithMimeType
extends Serializable,
Comparable<NamedWithMimeType> {
    public String getName();

    public MimeType getMimeType();

    @Override
    default public int compareTo(NamedWithMimeType o) {
        int c = _Strings.compareNullsFirst((String)this.getName(), (String)(o != null ? o.getName() : null));
        if (c != 0) {
            return c;
        }
        return _Strings.compareNullsFirst((String)this.getMimeType().getBaseType(), o != null ? o.getMimeType().getBaseType() : null);
    }

    public static enum CommonMimeType {
        AAC("audio/aac", new String[0]),
        ABW("application/x-abiword", new String[0]),
        ARC("application/x-freearc", new String[0]),
        AVI("video/x-msvideo", new String[0]),
        AZW("application/vnd.amazon.ebook", new String[0]),
        BIN("application/octet-stream", new String[0]),
        BMP("image/bmp", new String[0]),
        BZ("application/x-bzip", new String[0]),
        BZ2("application/x-bzip2", new String[0]),
        CSH("application/x-csh", new String[0]),
        CSS("text/css", new String[0]),
        CSV("text/csv", new String[0]),
        EOT("application/vnd.ms-fontobject", new String[0]),
        EPUB("application/epub+zip", new String[0]),
        GZ("application/gzip", new String[0]),
        GIF("image/gif", new String[0]),
        HTML("text/html", "htm"),
        ICO("image/vnd.microsoft.icon", new String[0]),
        ICS("text/calendar", new String[0]),
        JAR("application/java-archive", new String[0]),
        JPEG("image/jpeg", "jpg"),
        JS("text/javascript", new String[0]),
        JSON("application/json", new String[0]),
        JSONLD("application/ld+json", new String[0]),
        MIDI("audio/midi", "mid"),
        MJS("text/javascript", new String[0]),
        MP3("audio/mpeg", new String[0]),
        MPEG("video/mpeg", new String[0]),
        MPKG("application/vnd.apple.installer+xml", new String[0]),
        ODP("application/vnd.oasis.opendocument.presentation", new String[0]),
        ODS("application/vnd.oasis.opendocument.spreadsheet", new String[0]),
        ODT("application/vnd.oasis.opendocument.text", new String[0]),
        OGA("audio/ogg", new String[0]),
        OGV("video/ogg", new String[0]),
        OGX("application/ogg", new String[0]),
        OPUS("audio/opus", new String[0]),
        OTF("font/otf", new String[0]),
        PNG("image/png", new String[0]),
        PDF("application/pdf", new String[0]),
        PHP("application/php", new String[0]),
        RAR("application/x-rar-compressed", new String[0]),
        RTF("application/rtf", new String[0]),
        SH("application/x-sh", new String[0]),
        SVG("image/svg+xml", new String[0]),
        SWF("application/x-shockwave-flash", new String[0]),
        TAR("application/x-tar", new String[0]),
        TIFF("image/tiff", "tif"),
        TS("video/mp2t", new String[0]),
        TTF("font/ttf", new String[0]),
        TXT("text/plain", new String[0]),
        LOG("text/plain", new String[0]),
        PROPERTIES("text/plain", new String[0]),
        VSD("application/vnd.visio", new String[0]),
        WAV("audio/wav", new String[0]),
        WEBA("audio/webm", new String[0]),
        WEBM("video/webm", new String[0]),
        WEBP("image/webp", new String[0]),
        WOFF("font/woff", new String[0]),
        WOFF2("font/woff2", new String[0]),
        XHTML("application/xhtml+xml", new String[0]),
        XML("application/xml", new String[0]),
        XSD("application/xml", new String[0]),
        XUL("application/vnd.mozilla.xul+xml", new String[0]),
        YAML("text/vnd.yaml", "yml"),
        ZIP("application/zip", new String[0]),
        _7Z("application/x-7z-compressed", new String[0]),
        DOC("application/msword", new String[0]),
        DOT("application/msword", new String[0]),
        DOCX("application/vnd.openxmlformats-officedocument.wordprocessingml.document", new String[0]),
        DOTX("application/vnd.openxmlformats-officedocument.wordprocessingml.template", new String[0]),
        DOCM("application/vnd.ms-word.document.macroEnabled.12", new String[0]),
        DOTM("application/vnd.ms-word.template.macroEnabled.12", new String[0]),
        XLS("application/vnd.ms-excel", new String[0]),
        XLT("application/vnd.ms-excel", new String[0]),
        XLA("application/vnd.ms-excel", new String[0]),
        XLSX("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", new String[0]),
        XLTX("application/vnd.openxmlformats-officedocument.spreadsheetml.template", new String[0]),
        XLSM("application/vnd.ms-excel.sheet.macroEnabled.12", new String[0]),
        XLTM("application/vnd.ms-excel.template.macroEnabled.12", new String[0]),
        XLAM("application/vnd.ms-excel.addin.macroEnabled.12", new String[0]),
        XLSB("application/vnd.ms-excel.sheet.binary.macroEnabled.12", new String[0]),
        PPT("application/vnd.ms-powerpoint", new String[0]),
        POT("application/vnd.ms-powerpoint", new String[0]),
        PPS("application/vnd.ms-powerpoint", new String[0]),
        PPA("application/vnd.ms-powerpoint", new String[0]),
        PPTX("application/vnd.openxmlformats-officedocument.presentationml.presentation", new String[0]),
        POTX("application/vnd.openxmlformats-officedocument.presentationml.template", new String[0]),
        PPSX("application/vnd.openxmlformats-officedocument.presentationml.slideshow", new String[0]),
        PPAM("application/vnd.ms-powerpoint.addin.macroEnabled.12", new String[0]),
        PPTM("application/vnd.ms-powerpoint.presentation.macroEnabled.12", new String[0]),
        POTM("application/vnd.ms-powerpoint.template.macroEnabled.12", new String[0]),
        PPSM("application/vnd.ms-powerpoint.slideshow.macroEnabled.12", new String[0]),
        MDB("application/vnd.ms-access", new String[0]);

        final MimeType mimeType;
        final Can<String> proposedFileExtensions;

        private CommonMimeType(String primaryType, String ... proposedFileExtensions) {
            this.mimeType = CommonMimeType.newMimeType(primaryType);
            this.proposedFileExtensions = proposedFileExtensions.length > 0 ? Can.ofArray((Object[])proposedFileExtensions) : Can.ofSingleton((Object)this.name().toLowerCase());
        }

        public String getBaseType() {
            return this.getMimeType().getBaseType();
        }

        static MimeType newMimeType(String primaryType, String subtype) {
            try {
                return new MimeType(primaryType, subtype);
            }
            catch (MimeTypeParseException e) {
                throw new IllegalArgumentException(e);
            }
        }

        static MimeType newMimeType(String baseType) {
            try {
                return new MimeType(baseType);
            }
            catch (MimeTypeParseException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public boolean matches(MimeType otherMimeType) {
            return this.mimeType.match(otherMimeType);
        }

        public MimeType getMimeType() {
            return this.mimeType;
        }

        public Can<String> getProposedFileExtensions() {
            return this.proposedFileExtensions;
        }
    }
}

