/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.base._Text;

@Named(value="isis.applib.value.Markup")
@Value
@XmlJavaTypeAdapter(value=JaxbToStringAdapter.class)
public final class Markup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String html;

    public static Markup valueOf(String html) {
        return new Markup(html);
    }

    public Markup() {
        this(null);
    }

    public Markup(String html) {
        this.html = html != null ? html : "";
    }

    public String asHtml() {
        return this.html;
    }

    public String toString() {
        return String.format("Markup[length=%d,content=%s]", this.html.length(), Markup.summarizeHtmlAsTitle(this.html));
    }

    public static String summarizeHtmlAsTitle(String html) {
        return _Strings.ellipsifyAtEnd((CharSequence)_Text.normalize((Can)_Text.getLines((String)html)).stream().collect(Collectors.joining(" ")), (int)255, (CharSequence)"...");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Markup)) {
            return false;
        }
        Markup other = (Markup)o;
        String this$html = this.html;
        String other$html = other.html;
        return !(this$html == null ? other$html != null : !this$html.equals(other$html));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $html = this.html;
        result = result * 59 + ($html == null ? 43 : $html.hashCode());
        return result;
    }

    public static final class JaxbToStringAdapter
    extends XmlAdapter<String, Markup> {
        private final Base64.Encoder encoder = Base64.getEncoder();
        private final Base64.Decoder decoder = Base64.getDecoder();

        public Markup unmarshal(String v) throws Exception {
            return v != null ? new Markup(_Strings.ofBytes((byte[])this.decoder.decode(v), (Charset)StandardCharsets.UTF_8)) : null;
        }

        public String marshal(Markup v) throws Exception {
            return v != null ? this.encoder.encodeToString(_Strings.toBytes((String)v.asHtml(), (Charset)StandardCharsets.UTF_8)) : null;
        }
    }
}

