/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import java.io.Serializable;
import java.util.function.UnaryOperator;
import javax.inject.Named;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import lombok.NonNull;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.value.OpenUrlStrategy;
import org.apache.isis.commons.internal.base._Blackhole;
import org.apache.isis.commons.internal.hardening._Hardening;
import org.springframework.lang.Nullable;

@Named(value="isis.applib.value.LocalResourcePath")
@Value
@XmlJavaTypeAdapter(value=JaxbToStringAdapter.class)
public final class LocalResourcePath
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String path;
    @NonNull
    private final OpenUrlStrategy openUrlStrategy;

    public LocalResourcePath(@Nullable String path) throws IllegalArgumentException {
        this(path, null);
    }

    public LocalResourcePath(@Nullable String path, @Nullable OpenUrlStrategy openUrlStrategy) throws IllegalArgumentException {
        this.validate(path);
        this.path = path != null ? path : "";
        this.openUrlStrategy = openUrlStrategy != null ? openUrlStrategy : OpenUrlStrategy.NEW_WINDOW;
    }

    @NonNull
    public String getValue() {
        return this.path;
    }

    @NonNull
    public String getEffectivePath(@NonNull UnaryOperator<String> contextPathPrepender) {
        if (contextPathPrepender == null) {
            throw new NullPointerException("contextPathPrepender is marked non-null but is null");
        }
        return (String)contextPathPrepender.apply(this.path);
    }

    public String toString() {
        return "LocalResourcePath [path=" + this.path + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof LocalResourcePath && this.isEqualTo((LocalResourcePath)obj);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean isEqualTo(LocalResourcePath other) {
        if (other == null) {
            return false;
        }
        return this.getValue().equals(other.getValue());
    }

    private void validate(String path) throws IllegalArgumentException {
        if (path == null) {
            return;
        }
        try {
            _Blackhole.consume((Object)_Hardening.toUrlWithXssGuard((String)("http://localhost/" + path)));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("the given local path has an invalid syntax: '%s'", path), e);
        }
    }

    @NonNull
    public OpenUrlStrategy getOpenUrlStrategy() {
        return this.openUrlStrategy;
    }

    public static class JaxbToStringAdapter
    extends XmlAdapter<String, LocalResourcePath> {
        public LocalResourcePath unmarshal(String path) {
            return path != null ? new LocalResourcePath(path) : null;
        }

        public String marshal(LocalResourcePath localResourcePath) {
            return localResourcePath != null ? localResourcePath.getValue() : null;
        }
    }
}

