/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.inject.Named;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import lombok.NonNull;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.jaxb.PrimitiveJaxbAdapters;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.NamedWithMimeType;
import org.apache.isis.commons.internal.base._Strings;

@Named(value="isis.applib.value.Clob")
@Value
@XmlJavaTypeAdapter(value=JaxbToStringAdapter.class)
public final class Clob
implements NamedWithMimeType {
    private static final long serialVersionUID = 8694189924062378527L;
    private final String name;
    private final MimeType mimeType;
    private final CharSequence chars;

    public static Clob of(String name, NamedWithMimeType.CommonMimeType mimeType, CharSequence content) {
        String proposedFileExtension = mimeType.getProposedFileExtensions().getFirst().orElse("");
        String fileName = _Strings.asFileNameWithExtension((String)name, (String)proposedFileExtension);
        return new Clob(fileName, mimeType.getMimeType(), content);
    }

    public Clob(String name, String primaryType, String subType, char[] chars) {
        this(name, primaryType, subType, new String(chars));
    }

    public Clob(String name, String mimeTypeBase, char[] chars) {
        this(name, mimeTypeBase, (CharSequence)new String(chars));
    }

    public Clob(String name, MimeType mimeType, char[] chars) {
        this(name, mimeType, (CharSequence)new String(chars));
    }

    public Clob(String name, String primaryType, String subType, CharSequence chars) {
        this(name, NamedWithMimeType.CommonMimeType.newMimeType(primaryType, subType), chars);
    }

    public Clob(String name, String mimeTypeBase, CharSequence chars) {
        this(name, NamedWithMimeType.CommonMimeType.newMimeType(mimeTypeBase), chars);
    }

    public Clob(String name, MimeType mimeType, CharSequence chars) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (mimeType == null) {
            throw new IllegalArgumentException("MimeType cannot be null");
        }
        if (name.contains(":")) {
            throw new IllegalArgumentException("Name cannot contain ':'");
        }
        if (chars == null) {
            throw new IllegalArgumentException("Chars cannot be null");
        }
        this.name = name;
        this.mimeType = mimeType;
        this.chars = chars;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MimeType getMimeType() {
        return this.mimeType;
    }

    public CharSequence getChars() {
        return this.chars;
    }

    public Blob toBlob(@NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return new Blob(this.getName(), this.getMimeType(), _Strings.toBytes((String)this.getChars().toString(), (Charset)charset));
    }

    public void writeCharsTo(Writer wr) throws IOException {
        if (wr != null && this.chars != null) {
            wr.append(this.chars);
        }
    }

    public String asString() {
        StringWriter sw = new StringWriter();
        this.writeCharsTo(sw);
        return sw.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Clob clob = (Clob)o;
        return Objects.equals(this.name, clob.name) && Objects.equals(this.mimeType.toString(), clob.mimeType.toString()) && Objects.equals(this.chars, clob.chars);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.mimeType.toString(), this.chars);
    }

    public String toString() {
        return this.getName() + " [" + this.getMimeType().getBaseType() + "]: " + this.getChars().length() + " chars";
    }

    public static final class JaxbToStringAdapter
    extends XmlAdapter<String, Clob> {
        private final PrimitiveJaxbAdapters.BytesAdapter bytesAdapter = new PrimitiveJaxbAdapters.BytesAdapter();

        public Clob unmarshal(String data) throws Exception {
            if (data == null) {
                return null;
            }
            int colonIdx = data.indexOf(58);
            String name = data.substring(0, colonIdx);
            int colon2Idx = data.indexOf(":", colonIdx + 1);
            String mimeTypeBase = data.substring(colonIdx + 1, colon2Idx);
            String payload = data.substring(colon2Idx + 1);
            byte[] bytes = this.bytesAdapter.unmarshal(payload);
            try {
                return new Clob(name, new MimeType(mimeTypeBase), (CharSequence)new String(bytes, StandardCharsets.UTF_8));
            }
            catch (MimeTypeParseException e) {
                throw new RuntimeException(e);
            }
        }

        public String marshal(Clob clob) throws Exception {
            if (clob == null) {
                return null;
            }
            return clob.getName() + ':' + clob.getMimeType().getBaseType() + ':' + this.bytesAdapter.marshal(clob.getChars().toString().getBytes(StandardCharsets.UTF_8));
        }
    }
}

