/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.inject.Named;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import lombok.NonNull;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.jaxb.PrimitiveJaxbAdapters;
import org.apache.isis.applib.util.ZipReader;
import org.apache.isis.applib.util.ZipWriter;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.NamedWithMimeType;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.commons.internal.image._Images;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="isis.applib.value.Blob")
@Value
@XmlJavaTypeAdapter(value=JaxbToStringAdapter.class)
public final class Blob
implements NamedWithMimeType {
    private static final Logger log = LogManager.getLogger(Blob.class);
    private static final long serialVersionUID = 5659679806709601263L;
    private final MimeType mimeType;
    private final byte[] bytes;
    private final String name;

    public static Blob of(String name, NamedWithMimeType.CommonMimeType mimeType, byte[] content) {
        String proposedFileExtension = mimeType.getProposedFileExtensions().getFirst().orElse("");
        String fileName = _Strings.asFileNameWithExtension((String)name, (String)proposedFileExtension);
        return new Blob(fileName, mimeType.getMimeType(), content);
    }

    public Blob(String name, String primaryType, String subtype, byte[] bytes) {
        this(name, NamedWithMimeType.CommonMimeType.newMimeType(primaryType, subtype), bytes);
    }

    public Blob(String name, String mimeTypeBase, byte[] bytes) {
        this(name, NamedWithMimeType.CommonMimeType.newMimeType(mimeTypeBase), bytes);
    }

    public Blob(String name, MimeType mimeType, byte[] bytes) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (mimeType == null) {
            throw new IllegalArgumentException("MimeType cannot be null");
        }
        if (name.contains(":")) {
            throw new IllegalArgumentException("Name cannot contain ':'");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Bytes cannot be null");
        }
        this.name = name;
        this.mimeType = mimeType;
        this.bytes = bytes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MimeType getMimeType() {
        return this.mimeType;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public Clob toClob(@NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return new Clob(this.getName(), this.getMimeType(), (CharSequence)_Strings.ofBytes((byte[])this.getBytes(), (Charset)charset));
    }

    public void writeBytesTo(OutputStream os) throws IOException {
        if (os == null) {
            return;
        }
        if (this.bytes != null) {
            os.write(this.bytes);
        }
    }

    public void consume(Consumer<InputStream> consumer) throws IOException {
        byte[] bytes = Optional.ofNullable(this.getBytes()).orElse(new byte[0]);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            consumer.accept(bis);
        }
    }

    public <R> R digest(@NonNull Function<InputStream, R> digester) throws IOException {
        if (digester == null) {
            throw new NullPointerException("digester is marked non-null but is null");
        }
        byte[] bytes = Optional.ofNullable(this.getBytes()).orElse(new byte[0]);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            R r = digester.apply(bis);
            return r;
        }
    }

    public Blob zip() {
        ZipWriter zipWriter = ZipWriter.newInstance();
        zipWriter.nextEntry(this.getName(), outputStream -> outputStream.writeBytes(this.getBytes()));
        return Blob.of(this.getName() + ".zip", NamedWithMimeType.CommonMimeType.ZIP, zipWriter.toBytes());
    }

    public Blob unZip(@NonNull NamedWithMimeType.CommonMimeType resultingMimeType) {
        if (resultingMimeType == null) {
            throw new NullPointerException("resultingMimeType is marked non-null but is null");
        }
        return this.digest(is -> ZipReader.digest(is, (zipEntry, zipInputStream) -> {
            byte[] unzippedBytes;
            if (zipEntry.isDirectory()) {
                return null;
            }
            try {
                unzippedBytes = _Bytes.of((InputStream)zipInputStream);
            }
            catch (IOException e) {
                throw _Exceptions.unrecoverable((Throwable)e, (String)"failed to read zip entry %s", (Object[])new Object[]{zipEntry.getName()});
            }
            return Blob.of(zipEntry.getName(), resultingMimeType, unzippedBytes);
        })).orElse(Blob.of("blob_unzip_failed", resultingMimeType, new byte[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Blob blob = (Blob)o;
        return Objects.equals(this.mimeType.toString(), blob.mimeType.toString()) && Arrays.equals(this.bytes, blob.bytes) && Objects.equals(this.name, blob.name);
    }

    public int hashCode() {
        int result = Objects.hash(this.mimeType.toString(), this.name);
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public String toString() {
        return this.getName() + " [" + this.getMimeType().getBaseType() + "]: " + this.getBytes().length + " bytes";
    }

    public Optional<BufferedImage> asImage() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return Optional.empty();
        }
        MimeType mimeType = this.getMimeType();
        if (mimeType == null || !mimeType.getPrimaryType().equals("image")) {
            return Optional.empty();
        }
        try {
            BufferedImage img = _Images.fromBytes((byte[])this.getBytes());
            return Optional.ofNullable(img);
        }
        catch (Exception e) {
            log.error("failed to read image data", (Throwable)e);
            return Optional.empty();
        }
    }

    public static final class JaxbToStringAdapter
    extends XmlAdapter<String, Blob> {
        private final PrimitiveJaxbAdapters.BytesAdapter bytesAdapter = new PrimitiveJaxbAdapters.BytesAdapter();

        public Blob unmarshal(String data) throws Exception {
            if (data == null) {
                return null;
            }
            int colonIdx = data.indexOf(58);
            String name = data.substring(0, colonIdx);
            int colon2Idx = data.indexOf(":", colonIdx + 1);
            String mimeTypeBase = data.substring(colonIdx + 1, colon2Idx);
            String payload = data.substring(colon2Idx + 1);
            byte[] bytes = this.bytesAdapter.unmarshal(payload);
            try {
                return new Blob(name, new MimeType(mimeTypeBase), bytes);
            }
            catch (MimeTypeParseException e) {
                throw new RuntimeException(e);
            }
        }

        public String marshal(Blob blob) throws Exception {
            if (blob == null) {
                return null;
            }
            String s = blob.getName() + ":" + blob.getMimeType().getBaseType() + ":" + this.bytesAdapter.marshal(blob.getBytes());
            return s;
        }
    }
}

