/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util.schema;

import java.io.Writer;
import javax.xml.bind.JAXBException;
import lombok.NonNull;
import org.apache.isis.commons.internal.resources._Xml;
import org.apache.isis.schema.common.v2.DifferenceDto;
import org.apache.isis.schema.common.v2.PeriodDto;
import org.apache.isis.schema.ixn.v2.MemberExecutionDto;
import org.apache.isis.schema.ixn.v2.MetricsDto;
import org.apache.isis.schema.ixn.v2.ObjectCountsDto;

public final class MemberExecutionDtoUtils {
    public static <T extends MemberExecutionDto> T clone(T dto) {
        return (T)((MemberExecutionDto)_Xml.clone(dto).getValue().orElseThrow());
    }

    public static MetricsDto metricsFor(MemberExecutionDto executionDto) {
        MetricsDto metrics = executionDto.getMetrics();
        if (metrics == null) {
            metrics = new MetricsDto();
            executionDto.setMetrics(metrics);
        }
        return metrics;
    }

    public static PeriodDto timingsFor(MetricsDto metricsDto) {
        PeriodDto timings = metricsDto.getTimings();
        if (timings == null) {
            timings = new PeriodDto();
            metricsDto.setTimings(timings);
        }
        return timings;
    }

    public static ObjectCountsDto objectCountsFor(MetricsDto metricsDto) {
        ObjectCountsDto objectCounts = metricsDto.getObjectCounts();
        if (objectCounts == null) {
            objectCounts = new ObjectCountsDto();
            metricsDto.setObjectCounts(objectCounts);
        }
        return objectCounts;
    }

    public static DifferenceDto numberObjectsLoadedFor(ObjectCountsDto objectCountsDto) {
        DifferenceDto differenceDto = objectCountsDto.getLoaded();
        if (differenceDto == null) {
            differenceDto = new DifferenceDto();
            objectCountsDto.setLoaded(differenceDto);
        }
        return differenceDto;
    }

    public static DifferenceDto numberObjectsDirtiedFor(ObjectCountsDto objectCountsDto) {
        DifferenceDto differenceDto = objectCountsDto.getDirtied();
        if (differenceDto == null) {
            differenceDto = new DifferenceDto();
            objectCountsDto.setDirtied(differenceDto);
        }
        return differenceDto;
    }

    public static <T extends MemberExecutionDto> String toXml(@NonNull T dto) {
        if (dto == null) {
            throw new NullPointerException("dto is marked non-null but is null");
        }
        return (String)_Xml.writeXml(dto, (_Xml.WriteOptions)MemberExecutionDtoUtils.writeOptions()).getValue().orElseThrow();
    }

    public static <T extends MemberExecutionDto> void toXml(@NonNull T dto, @NonNull Writer writer) throws JAXBException {
        if (dto == null) {
            throw new NullPointerException("dto is marked non-null but is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        _Xml.writeXml(dto, (Writer)writer, (_Xml.WriteOptions)MemberExecutionDtoUtils.writeOptions());
    }

    private static _Xml.WriteOptions writeOptions() {
        return _Xml.WriteOptions.builder().useContextCache(true).formattedOutput(true).allowMissingRootElement(true).build();
    }
}

