/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.isis.applib.jaxb.JavaTimeXMLGregorianCalendarMarshalling;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.semantics.ValueDecomposition;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.commons.internal.resources._Json;
import org.apache.isis.schema.cmd.v2.MapDto;
import org.apache.isis.schema.cmd.v2.ParamDto;
import org.apache.isis.schema.common.v2.BlobDto;
import org.apache.isis.schema.common.v2.ClobDto;
import org.apache.isis.schema.common.v2.EnumDto;
import org.apache.isis.schema.common.v2.NamedValueWithTypeDto;
import org.apache.isis.schema.common.v2.TypedTupleDto;
import org.apache.isis.schema.common.v2.ValueDto;
import org.apache.isis.schema.common.v2.ValueType;
import org.apache.isis.schema.common.v2.ValueWithTypeDto;
import org.springframework.lang.Nullable;

public final class CommonDtoUtils {
    public static ValueWithTypeDto getFundamentalValueFromJson(@NonNull ValueType valueType, @Nullable String json) {
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        ValueWithTypeDto valueDto = new ValueWithTypeDto();
        valueDto.setType(valueType);
        if (_Strings.isNullOrEmpty((CharSequence)json)) {
            return valueDto;
        }
        switch (valueType) {
            case REFERENCE: 
            case COMPOSITE: 
            case COLLECTION: {
                throw _Exceptions.unsupportedOperation((String)"valueType %s is not fundamental", (Object[])new Object[]{valueType});
            }
            case STRING: {
                valueDto.setString(json);
                return valueDto;
            }
            case BYTE: {
                valueDto.setByte(Byte.valueOf(json));
                return valueDto;
            }
            case SHORT: {
                valueDto.setShort(Short.valueOf(json));
                return valueDto;
            }
            case INT: {
                valueDto.setInt(Integer.valueOf(json));
                return valueDto;
            }
            case LONG: {
                valueDto.setLong(Long.valueOf(json));
                return valueDto;
            }
            case CHAR: {
                valueDto.setChar(json);
                return valueDto;
            }
            case BOOLEAN: {
                valueDto.setBoolean(Boolean.valueOf(json));
                return valueDto;
            }
            case FLOAT: {
                valueDto.setFloat(Float.valueOf(json));
                return valueDto;
            }
            case DOUBLE: {
                valueDto.setDouble(Double.valueOf(json));
                return valueDto;
            }
            case BIG_INTEGER: {
                valueDto.setBigInteger(new BigInteger(json));
                return valueDto;
            }
            case BIG_DECIMAL: {
                valueDto.setBigDecimal(new BigDecimal(json));
                return valueDto;
            }
            case LOCAL_DATE: {
                LocalDate argValue = LocalDate.parse(json);
                valueDto.setLocalDate(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case LOCAL_TIME: {
                LocalTime argValue = LocalTime.parse(json);
                valueDto.setLocalTime(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case LOCAL_DATE_TIME: {
                LocalDateTime argValue = LocalDateTime.parse(json);
                valueDto.setLocalDateTime(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case OFFSET_DATE_TIME: {
                OffsetDateTime argValue = OffsetDateTime.parse(json);
                valueDto.setOffsetDateTime(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case OFFSET_TIME: {
                OffsetTime argValue = OffsetTime.parse(json);
                valueDto.setOffsetTime(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case ZONED_DATE_TIME: {
                ZonedDateTime argValue = ZonedDateTime.parse(json);
                valueDto.setZonedDateTime(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case ENUM: {
                EnumDto enumDto = (EnumDto)_Json.readJson(EnumDto.class, (String)json, (_Json.JsonCustomizer[])new _Json.JsonCustomizer[0]).getValue().orElseThrow();
                valueDto.setEnum(enumDto);
                return valueDto;
            }
            case BLOB: {
                BlobDto blobDto = (BlobDto)_Json.readJson(BlobDto.class, (String)json, (_Json.JsonCustomizer[])new _Json.JsonCustomizer[0]).getValue().orElseThrow();
                valueDto.setBlob(blobDto);
                return valueDto;
            }
            case CLOB: {
                ClobDto clobDto = (ClobDto)_Json.readJson(ClobDto.class, (String)json, (_Json.JsonCustomizer[])new _Json.JsonCustomizer[0]).getValue().orElseThrow();
                valueDto.setClob(clobDto);
                return valueDto;
            }
            case VOID: {
                return valueDto;
            }
        }
        throw _Exceptions.unmatchedCase((Object)valueType);
    }

    public static String getFundamentalValueAsJson(@Nullable ValueWithTypeDto valueDto) {
        if (valueDto == null) {
            return null;
        }
        return CommonDtoUtils.getFundamentalValueAsJson(valueDto.getType(), (ValueDto)valueDto);
    }

    public static String getFundamentalValueAsJson(@NonNull ValueType valueType, @Nullable ValueDto valueDto) {
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        if (valueDto == null) {
            return null;
        }
        switch (valueType) {
            case REFERENCE: 
            case COMPOSITE: 
            case COLLECTION: {
                throw _Exceptions.unsupportedOperation((String)"valueType %s is not fundamental", (Object[])new Object[]{valueType});
            }
            case STRING: {
                return valueDto.getString();
            }
            case BYTE: {
                return _NullSafe.toString((Object)valueDto.getByte());
            }
            case SHORT: {
                return _NullSafe.toString((Object)valueDto.getShort());
            }
            case INT: {
                return _NullSafe.toString((Object)valueDto.getInt());
            }
            case LONG: {
                return _NullSafe.toString((Object)valueDto.getLong());
            }
            case FLOAT: {
                return _NullSafe.toString((Object)valueDto.getFloat());
            }
            case DOUBLE: {
                return _NullSafe.toString((Object)valueDto.getDouble());
            }
            case BOOLEAN: {
                return _NullSafe.toString((Object)valueDto.isBoolean());
            }
            case CHAR: {
                String aChar = valueDto.getChar();
                if (_Strings.isNullOrEmpty((CharSequence)aChar)) {
                    return null;
                }
                return "" + aChar.charAt(0);
            }
            case BIG_DECIMAL: {
                return _NullSafe.toString((Object)valueDto.getBigDecimal());
            }
            case BIG_INTEGER: {
                return _NullSafe.toString((Object)valueDto.getBigInteger());
            }
            case LOCAL_DATE: {
                return _NullSafe.toString((Object)valueDto.getLocalDate());
            }
            case LOCAL_TIME: {
                return _NullSafe.toString((Object)valueDto.getLocalTime());
            }
            case LOCAL_DATE_TIME: {
                return _NullSafe.toString((Object)valueDto.getLocalDateTime());
            }
            case OFFSET_DATE_TIME: {
                return _NullSafe.toString((Object)valueDto.getOffsetDateTime());
            }
            case OFFSET_TIME: {
                return _NullSafe.toString((Object)valueDto.getOffsetTime());
            }
            case ZONED_DATE_TIME: {
                return _NullSafe.toString((Object)valueDto.getZonedDateTime());
            }
            case ENUM: {
                return CommonDtoUtils.dtoToJson(valueDto.getEnum());
            }
            case BLOB: {
                return CommonDtoUtils.dtoToJson(valueDto.getBlob());
            }
            case CLOB: {
                return CommonDtoUtils.dtoToJson(valueDto.getClob());
            }
            case VOID: {
                return null;
            }
        }
        throw _Exceptions.unmatchedCase((Object)valueType);
    }

    @Nullable
    public static String getCompositeValueAsJson(@Nullable TypedTupleDto composite) {
        return composite != null ? _Json.toString((Object)composite, (_Json.JsonCustomizer[])new _Json.JsonCustomizer[]{_Json::jaxbAnnotationSupport, _Json::onlyIncludeNonNull}) : null;
    }

    @Nullable
    public static TypedTupleDto getCompositeValueFromJson(@Nullable String json) {
        return _Strings.isNotEmpty((CharSequence)json) ? (TypedTupleDto)_Json.readJson(TypedTupleDto.class, (String)json, (_Json.JsonCustomizer[])new _Json.JsonCustomizer[]{_Json::jaxbAnnotationSupport}).getValue().orElseThrow() : null;
    }

    private static String dtoToJson(@Nullable Object dto) {
        return _Json.toString((Object)dto, (_Json.JsonCustomizer[])new _Json.JsonCustomizer[0]);
    }

    public static <D extends ValueDto> D recordFundamentalValue(@NonNull ValueType valueType, D valueDto, Object pojo) {
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        if (valueDto instanceof ValueWithTypeDto) {
            ((ValueWithTypeDto)valueDto).setType(valueType);
        }
        if (pojo == null) {
            return valueDto;
        }
        switch (valueType) {
            case REFERENCE: 
            case COMPOSITE: 
            case COLLECTION: {
                throw _Exceptions.unsupportedOperation((String)"valueType %s is not fundamental", (Object[])new Object[]{valueType});
            }
            case STRING: {
                String argValue = (String)pojo;
                valueDto.setString(argValue);
                return valueDto;
            }
            case BYTE: {
                Byte argValue = (Byte)pojo;
                valueDto.setByte(argValue);
                return valueDto;
            }
            case SHORT: {
                Short argValue = (Short)pojo;
                valueDto.setShort(argValue);
                return valueDto;
            }
            case INT: {
                Integer argValue = (Integer)pojo;
                valueDto.setInt(argValue);
                return valueDto;
            }
            case LONG: {
                Long argValue = (Long)pojo;
                valueDto.setLong(argValue);
                return valueDto;
            }
            case CHAR: {
                Character argValue = (Character)pojo;
                valueDto.setChar("" + argValue);
                return valueDto;
            }
            case BOOLEAN: {
                Boolean argValue = (Boolean)pojo;
                valueDto.setBoolean(argValue);
                return valueDto;
            }
            case FLOAT: {
                Float argValue = (Float)pojo;
                valueDto.setFloat(argValue);
                return valueDto;
            }
            case DOUBLE: {
                Double argValue = (Double)pojo;
                valueDto.setDouble(argValue);
                return valueDto;
            }
            case BIG_INTEGER: {
                BigInteger argValue = (BigInteger)pojo;
                valueDto.setBigInteger(argValue);
                return valueDto;
            }
            case BIG_DECIMAL: {
                BigDecimal argValue = (BigDecimal)pojo;
                valueDto.setBigDecimal(argValue);
                return valueDto;
            }
            case LOCAL_DATE: {
                LocalDate argValue = (LocalDate)pojo;
                valueDto.setLocalDate(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case LOCAL_TIME: {
                LocalTime argValue = (LocalTime)pojo;
                valueDto.setLocalTime(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case LOCAL_DATE_TIME: {
                LocalDateTime argValue = (LocalDateTime)pojo;
                valueDto.setLocalDateTime(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case OFFSET_DATE_TIME: {
                OffsetDateTime argValue = (OffsetDateTime)pojo;
                valueDto.setOffsetDateTime(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case OFFSET_TIME: {
                OffsetTime argValue = (OffsetTime)pojo;
                valueDto.setOffsetTime(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case ZONED_DATE_TIME: {
                ZonedDateTime argValue = (ZonedDateTime)pojo;
                valueDto.setZonedDateTime(JavaTimeXMLGregorianCalendarMarshalling.toXMLGregorianCalendar(argValue));
                return valueDto;
            }
            case ENUM: {
                Enum argValue = (Enum)pojo;
                EnumDto enumDto = new EnumDto();
                valueDto.setEnum(enumDto);
                enumDto.setEnumType(argValue.getClass().getName());
                enumDto.setEnumName(argValue.name());
                return valueDto;
            }
            case BLOB: {
                Blob blob = (Blob)pojo;
                if (blob != null) {
                    BlobDto blobDto = new BlobDto();
                    blobDto.setName(blob.getName());
                    blobDto.setBytes(blob.getBytes());
                    blobDto.setMimeType(blob.getMimeType().toString());
                    valueDto.setBlob(blobDto);
                }
                return valueDto;
            }
            case CLOB: {
                Clob clob = (Clob)pojo;
                if (clob != null) {
                    ClobDto clobDto = new ClobDto();
                    clobDto.setName(clob.getName());
                    clobDto.setChars(clob.getChars().toString());
                    clobDto.setMimeType(clob.getMimeType().toString());
                    valueDto.setClob(clobDto);
                }
                return valueDto;
            }
            case VOID: {
                return null;
            }
        }
        throw _Exceptions.unmatchedCase((Object)valueType);
    }

    public static Object getValueAsObject(@Nullable ValueWithTypeDto valueDto) {
        if (valueDto == null) {
            return null;
        }
        return CommonDtoUtils.getValueAsObject(valueDto.getType(), (ValueDto)valueDto);
    }

    public static Object getValueAsObject(@NonNull ValueType valueType, @Nullable ValueDto valueDto) {
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        if (valueDto == null) {
            return null;
        }
        switch (valueType) {
            case STRING: {
                return valueDto.getString();
            }
            case BYTE: {
                return valueDto.getByte();
            }
            case SHORT: {
                return valueDto.getShort();
            }
            case INT: {
                return valueDto.getInt();
            }
            case LONG: {
                return valueDto.getLong();
            }
            case FLOAT: {
                return valueDto.getFloat();
            }
            case DOUBLE: {
                return valueDto.getDouble();
            }
            case BOOLEAN: {
                return valueDto.isBoolean();
            }
            case CHAR: {
                String aChar = valueDto.getChar();
                if (_Strings.isNullOrEmpty((CharSequence)aChar)) {
                    return null;
                }
                return Character.valueOf(aChar.charAt(0));
            }
            case BIG_DECIMAL: {
                return valueDto.getBigDecimal();
            }
            case BIG_INTEGER: {
                return valueDto.getBigInteger();
            }
            case LOCAL_DATE: {
                return JavaTimeXMLGregorianCalendarMarshalling.toLocalDate(valueDto.getLocalDate());
            }
            case LOCAL_TIME: {
                return JavaTimeXMLGregorianCalendarMarshalling.toLocalTime(valueDto.getLocalTime());
            }
            case LOCAL_DATE_TIME: {
                return JavaTimeXMLGregorianCalendarMarshalling.toLocalDateTime(valueDto.getLocalDateTime());
            }
            case OFFSET_DATE_TIME: {
                return JavaTimeXMLGregorianCalendarMarshalling.toOffsetDateTime(valueDto.getOffsetDateTime());
            }
            case OFFSET_TIME: {
                return JavaTimeXMLGregorianCalendarMarshalling.toOffsetTime(valueDto.getOffsetTime());
            }
            case ZONED_DATE_TIME: {
                return JavaTimeXMLGregorianCalendarMarshalling.toZonedDateTime(valueDto.getZonedDateTime());
            }
            case ENUM: {
                EnumDto enumDto = valueDto.getEnum();
                String enumType = enumDto.getEnumType();
                Class enumClass = (Class)_Casts.uncheckedCast((Object)_Context.loadClassAndInitialize((String)enumType));
                return Enum.valueOf((Class)_Casts.uncheckedCast((Object)enumClass), enumDto.getEnumName());
            }
            case REFERENCE: {
                return valueDto.getReference();
            }
            case BLOB: {
                BlobDto blobDto = valueDto.getBlob();
                return new Blob(blobDto.getName(), blobDto.getMimeType(), blobDto.getBytes());
            }
            case CLOB: {
                ClobDto clobDto = valueDto.getClob();
                return new Clob(clobDto.getName(), clobDto.getMimeType(), (CharSequence)clobDto.getChars());
            }
            case VOID: {
                return null;
            }
        }
        throw _Exceptions.unmatchedCase((Object)valueType);
    }

    public static ValueWithTypeDto toValueWithTypeDto(@NonNull ValueType valueType, @Nullable ValueDto valueDto) {
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        if (valueDto instanceof ValueWithTypeDto) {
            ValueWithTypeDto downCast = (ValueWithTypeDto)valueDto;
            _Assert.assertEquals((Object)valueType, (Object)downCast.getType());
            return downCast;
        }
        ValueWithTypeDto liftedDto = new ValueWithTypeDto();
        liftedDto.setType(valueType);
        if (valueDto == null) {
            return liftedDto;
        }
        CommonDtoUtils._copy(valueType, valueDto, (ValueDto)liftedDto);
        return liftedDto;
    }

    public static String getMapValue(MapDto mapDto, String key) {
        if (mapDto == null) {
            return null;
        }
        Optional<MapDto.Entry> entryIfAny = CommonDtoUtils.entryIfAnyFor(mapDto, key);
        return entryIfAny.map(MapDto.Entry::getValue).orElse(null);
    }

    public static void putMapKeyValue(MapDto mapDto, String key, String value) {
        if (mapDto == null) {
            return;
        }
        Optional<MapDto.Entry> entryIfAny = CommonDtoUtils.entryIfAnyFor(mapDto, key);
        if (entryIfAny.isPresent()) {
            entryIfAny.get().setValue(value);
        } else {
            MapDto.Entry entry = new MapDto.Entry();
            entry.setKey(key);
            entry.setValue(value);
            mapDto.getEntry().add(entry);
        }
    }

    private static Optional<MapDto.Entry> entryIfAnyFor(MapDto mapDto, String key) {
        return mapDto.getEntry().stream().filter(entry -> Objects.equals(entry.getKey(), key)).findFirst();
    }

    public static <T> ValueWithTypeDto fundamentalType(ValueType vType, T value) {
        return CommonDtoUtils.recordFundamentalValue(vType, new ValueWithTypeDto(), value);
    }

    public static <T> ValueDecomposition fundamentalTypeAsDecomposition(ValueType vType, T value) {
        return ValueDecomposition.ofFundamental(CommonDtoUtils.fundamentalType(vType, value));
    }

    public static <T> TypedTupleBuilder<T> typedTupleBuilder(T value) {
        return new TypedTupleBuilder<T>(value);
    }

    public static Map<String, Object> typedTupleAsMap(TypedTupleDto dto) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(dto.getCardinality());
        dto.getElements().forEach(elementDto -> map.put(elementDto.getName(), CommonDtoUtils.getValueAsObject((ValueWithTypeDto)elementDto)));
        return map;
    }

    public static ParamDto paramDto(@NonNull String paramName) {
        if (paramName == null) {
            throw new NullPointerException("paramName is marked non-null but is null");
        }
        ParamDto paramDto = new ParamDto();
        if (paramName.isBlank()) {
            throw _Exceptions.illegalArgument((String)"paramName must not be blank '%s'", (Object[])new Object[]{paramName});
        }
        paramDto.setName(paramName);
        return paramDto;
    }

    public static void copy(@NonNull ValueWithTypeDto src, @NonNull ValueWithTypeDto dst) {
        if (src == null) {
            throw new NullPointerException("src is marked non-null but is null");
        }
        if (dst == null) {
            throw new NullPointerException("dst is marked non-null but is null");
        }
        ValueType valueType = src.getType();
        dst.setType(valueType);
        CommonDtoUtils._copy(valueType, (ValueDto)src, (ValueDto)dst);
    }

    private static void _copy(@NonNull ValueType valueType, @NonNull ValueDto src, @NonNull ValueDto dst) {
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        if (src == null) {
            throw new NullPointerException("src is marked non-null but is null");
        }
        if (dst == null) {
            throw new NullPointerException("dst is marked non-null but is null");
        }
        switch (valueType) {
            case BIG_DECIMAL: {
                dst.setBigDecimal(src.getBigDecimal());
                break;
            }
            case BIG_INTEGER: {
                dst.setBigInteger(src.getBigInteger());
                break;
            }
            case BLOB: {
                dst.setBlob(src.getBlob());
                break;
            }
            case BOOLEAN: {
                dst.setBoolean(src.isBoolean());
                break;
            }
            case BYTE: {
                dst.setByte(src.getByte());
                break;
            }
            case CHAR: {
                dst.setChar(src.getChar());
                break;
            }
            case CLOB: {
                dst.setClob(src.getClob());
                break;
            }
            case COLLECTION: {
                dst.setCollection(src.getCollection());
                break;
            }
            case COMPOSITE: {
                dst.setComposite(src.getComposite());
                break;
            }
            case DOUBLE: {
                dst.setDouble(src.getDouble());
                break;
            }
            case ENUM: {
                dst.setEnum(src.getEnum());
                break;
            }
            case FLOAT: {
                dst.setFloat(src.getFloat());
                break;
            }
            case INT: {
                dst.setInt(src.getInt());
                break;
            }
            case LOCAL_DATE: {
                dst.setLocalDate(src.getLocalDate());
                break;
            }
            case LOCAL_DATE_TIME: {
                dst.setLocalDateTime(src.getLocalDateTime());
                break;
            }
            case LOCAL_TIME: {
                dst.setLocalTime(src.getLocalTime());
                break;
            }
            case LONG: {
                dst.setLong(src.getLong());
                break;
            }
            case OFFSET_DATE_TIME: {
                dst.setOffsetDateTime(src.getOffsetDateTime());
                break;
            }
            case OFFSET_TIME: {
                dst.setOffsetTime(src.getOffsetTime());
                break;
            }
            case REFERENCE: {
                dst.setReference(src.getReference());
                break;
            }
            case SHORT: {
                dst.setShort(src.getShort());
                break;
            }
            case STRING: {
                dst.setString(src.getString());
                break;
            }
            case VOID: {
                break;
            }
            case ZONED_DATE_TIME: {
                dst.setZonedDateTime(src.getZonedDateTime());
                break;
            }
            default: {
                throw _Exceptions.unmatchedCase((Object)valueType);
            }
        }
    }

    private CommonDtoUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class TypedTupleBuilder<T> {
        private final T value;
        private final TypedTupleDto dto = new TypedTupleDto();

        public TypedTupleBuilder<T> addFundamentalType(ValueType vType, String fieldName, Function<T, Object> getter) {
            NamedValueWithTypeDto elementDto = new NamedValueWithTypeDto();
            _Assert.assertTrue((boolean)_Strings.isNotEmpty((CharSequence)fieldName));
            elementDto.setName(fieldName);
            this.dto.getElements().add(CommonDtoUtils.recordFundamentalValue(vType, elementDto, getter.apply(this.value)));
            return this;
        }

        public TypedTupleDto build() {
            this.dto.setType(this.value.getClass().getName());
            this.dto.setCardinality(this.dto.getElements().size());
            return this.dto;
        }

        public ValueDecomposition buildAsDecomposition() {
            return ValueDecomposition.ofComposite(this.build());
        }

        public TypedTupleBuilder(T value) {
            this.value = value;
        }
    }
}

