/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util.schema;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.util.JaxbUtil;
import org.apache.isis.applib.util.schema.CommonDtoUtils;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.schema.cmd.v2.ActionDto;
import org.apache.isis.schema.cmd.v2.CommandDto;
import org.apache.isis.schema.cmd.v2.MapDto;
import org.apache.isis.schema.cmd.v2.ParamsDto;
import org.apache.isis.schema.common.v2.OidsDto;
import org.apache.isis.schema.common.v2.PeriodDto;

public final class CommandDtoUtils {
    static JAXBContext jaxbContext;

    public static void init() {
        CommandDtoUtils.getJaxbContext();
    }

    static JAXBContext getJaxbContext() {
        if (jaxbContext == null) {
            jaxbContext = JaxbUtil.jaxbContextFor(CommandDto.class);
        }
        return jaxbContext;
    }

    public static CommandDto fromXml(Reader reader) {
        try {
            Unmarshaller un = CommandDtoUtils.getJaxbContext().createUnmarshaller();
            return (CommandDto)un.unmarshal(reader);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static CommandDto clone(CommandDto commandDto) {
        return CommandDtoUtils.fromXml(CommandDtoUtils.toXml(commandDto));
    }

    public static CommandDto fromXml(String xml) {
        return CommandDtoUtils.fromXml(new StringReader(xml));
    }

    public static CommandDto fromXml(Class<?> contextClass, String resourceName, Charset charset) throws IOException {
        String s = _Resources.loadAsString(contextClass, (String)resourceName, (Charset)charset);
        return CommandDtoUtils.fromXml(new StringReader(s));
    }

    public static String toXml(CommandDto commandDto) {
        CharArrayWriter caw = new CharArrayWriter();
        CommandDtoUtils.toXml(commandDto, caw);
        return caw.toString();
    }

    public static void toXml(CommandDto commandDto, Writer writer) {
        try {
            Marshaller m = CommandDtoUtils.getJaxbContext().createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)commandDto, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static OidsDto targetsFor(CommandDto dto) {
        OidsDto targets = dto.getTargets();
        if (targets == null) {
            targets = new OidsDto();
            dto.setTargets(targets);
        }
        return targets;
    }

    public static ParamsDto parametersFor(ActionDto actionDto) {
        ParamsDto parameters = actionDto.getParameters();
        if (parameters == null) {
            parameters = new ParamsDto();
            actionDto.setParameters(parameters);
        }
        return parameters;
    }

    public static PeriodDto timingsFor(CommandDto commandDto) {
        PeriodDto timings = commandDto.getTimings();
        if (timings == null) {
            timings = new PeriodDto();
            commandDto.setTimings(timings);
        }
        return timings;
    }

    public static String getUserData(CommandDto dto, String key) {
        if (dto == null || key == null) {
            return null;
        }
        return CommonDtoUtils.getMapValue(dto.getUserData(), key);
    }

    public static void setUserData(CommandDto dto, String key, String value) {
        if (dto == null || key == null || _Strings.isNullOrEmpty((CharSequence)value)) {
            return;
        }
        MapDto userData = CommandDtoUtils.userDataFor(dto);
        CommonDtoUtils.putMapKeyValue(userData, key, value);
    }

    public static void setUserData(CommandDto dto, String key, Bookmark bookmark) {
        if (dto == null || key == null || bookmark == null) {
            return;
        }
        CommandDtoUtils.setUserData(dto, key, bookmark.toString());
    }

    public static void clearUserData(CommandDto dto, String key) {
        if (dto == null || key == null) {
            return;
        }
        CommandDtoUtils.userDataFor(dto).getEntry().removeIf(x -> x.getKey().equals(key));
    }

    private static MapDto userDataFor(CommandDto commandDto) {
        MapDto userData = commandDto.getUserData();
        if (userData == null) {
            userData = new MapDto();
            commandDto.setUserData(userData);
        }
        return userData;
    }
}

