/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public class ZipWriter {
    private final ByteArrayOutputStream baos;
    private final ZipOutputStream zos;
    private final ZipOutputStreamWrapper writer;
    private final String failureMessage;
    private byte[] zippedBytes;

    public static ZipWriter newInstance() {
        return ZipWriter.ofFailureMessage("Unable to create zip");
    }

    public static ZipWriter ofFailureMessage(String failureMessage) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        ZipOutputStreamWrapper writer = new ZipOutputStreamWrapper(zos);
        return new ZipWriter(baos, zos, writer, failureMessage);
    }

    public void nextEntry(String zipEntryName, OnZipEntry onZipEntry) {
        if (this.zippedBytes != null) {
            throw new IllegalStateException("Cannot create a new ZipEntry an a closed ZipWriter");
        }
        try {
            this.zos.putNextEntry(new ZipEntry(zipEntryName));
            onZipEntry.accept(this.writer);
            this.zos.closeEntry();
        }
        catch (IOException e) {
            throw _Exceptions.unrecoverable((Throwable)e, (String)this.failureMessage);
        }
    }

    public byte[] toBytes() {
        if (this.zippedBytes == null) {
            try {
                this.zos.close();
            }
            catch (IOException e) {
                throw _Exceptions.unrecoverable((Throwable)e, (String)this.failureMessage);
            }
            this.zippedBytes = this.baos.toByteArray();
        }
        return this.zippedBytes;
    }

    private ZipWriter(ByteArrayOutputStream baos, ZipOutputStream zos, ZipOutputStreamWrapper writer, String failureMessage) {
        this.baos = baos;
        this.zos = zos;
        this.writer = writer;
        this.failureMessage = failureMessage;
    }

    private static ZipWriter of(ByteArrayOutputStream baos, ZipOutputStream zos, ZipOutputStreamWrapper writer, String failureMessage) {
        return new ZipWriter(baos, zos, writer, failureMessage);
    }

    @FunctionalInterface
    public static interface OnZipEntry {
        public void accept(ZipOutputStreamWrapper var1) throws IOException;
    }

    public static final class ZipOutputStreamWrapper {
        @NonNull
        private final ZipOutputStream zipOutputStream;

        public void writeCharactersUtf8(@Nullable CharSequence chars) throws IOException {
            this.writeCharacters(chars, StandardCharsets.UTF_8);
        }

        public void writeCharacters(@Nullable CharSequence chars, @NonNull Charset charset) throws IOException {
            if (charset == null) {
                throw new NullPointerException("charset is marked non-null but is null");
            }
            if (chars == null || chars.length() == 0) {
                return;
            }
            this.zipOutputStream.write(_Strings.toBytes((String)chars.toString(), (Charset)charset));
        }

        public void writeBytes(@Nullable byte[] bytes) throws IOException {
            if (_NullSafe.isEmpty((byte[])bytes)) {
                return;
            }
            this.zipOutputStream.write(bytes);
        }

        public void writeBytes(@Nullable byte[] bytes, int off, int len) throws IOException {
            if (_NullSafe.isEmpty((byte[])bytes)) {
                return;
            }
            this.zipOutputStream.write(bytes, off, len);
        }

        private ZipOutputStreamWrapper(@NonNull ZipOutputStream zipOutputStream) {
            if (zipOutputStream == null) {
                throw new NullPointerException("zipOutputStream is marked non-null but is null");
            }
            this.zipOutputStream = zipOutputStream;
        }

        public static ZipOutputStreamWrapper of(@NonNull ZipOutputStream zipOutputStream) {
            return new ZipOutputStreamWrapper(zipOutputStream);
        }

        @NonNull
        public ZipOutputStream getZipOutputStream() {
            return this.zipOutputStream;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ZipOutputStreamWrapper)) {
                return false;
            }
            ZipOutputStreamWrapper other = (ZipOutputStreamWrapper)o;
            ZipOutputStream this$zipOutputStream = this.getZipOutputStream();
            ZipOutputStream other$zipOutputStream = other.getZipOutputStream();
            return !(this$zipOutputStream == null ? other$zipOutputStream != null : !this$zipOutputStream.equals(other$zipOutputStream));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ZipOutputStream $zipOutputStream = this.getZipOutputStream();
            result = result * 59 + ($zipOutputStream == null ? 43 : $zipOutputStream.hashCode());
            return result;
        }

        public String toString() {
            return "ZipWriter.ZipOutputStreamWrapper(zipOutputStream=" + this.getZipOutputStream() + ")";
        }
    }
}

