/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.NonNull;
import org.springframework.lang.Nullable;

public class ZipReader {
    private static final Charset ENTRY_NAME_CHARSET = StandardCharsets.UTF_8;

    public static void read(@Nullable InputStream inputStream, @NonNull ZipVisistor zipVisistor) {
        if (zipVisistor == null) {
            throw new NullPointerException("zipVisistor is marked non-null but is null");
        }
        if (inputStream == null) {
            return;
        }
        try (ZipInputStream in = new ZipInputStream((InputStream)new BufferedInputStream(inputStream, 65536), ENTRY_NAME_CHARSET);){
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                if (zipVisistor.test(entry, in)) continue;
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <R> Optional<R> digest(@Nullable InputStream inputStream, @NonNull ZipDigester<R> zipDigester) {
        if (zipDigester == null) {
            throw new NullPointerException("zipDigester is marked non-null but is null");
        }
        if (inputStream == null) {
            return Optional.empty();
        }
        try (ZipInputStream in = new ZipInputStream((InputStream)new BufferedInputStream(inputStream, 65536), ENTRY_NAME_CHARSET);){
            ZipEntry entry;
            Object digest;
            do {
                if ((entry = in.getNextEntry()) == null) return Optional.empty();
            } while ((digest = zipDigester.apply(entry, in)) == null);
            Optional optional = Optional.of(digest);
            return optional;
        }
    }

    public static interface ZipDigester<R>
    extends BiFunction<ZipEntry, ZipInputStream, R> {
    }

    public static interface ZipVisistor
    extends BiPredicate<ZipEntry, ZipInputStream> {
    }
}

