/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.collections._Lists;

public class ToString<T> {
    private final List<String> names = _Lists.newArrayList();
    private final List<Function<? super T, ?>> getters = _Lists.newArrayList();
    private final BitSet omitIfAbsent = new BitSet();

    public static <T> ToString<T> toString(String name, Function<? super T, ?> getter) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(getter);
        return new ToString<T>(name, getter, false);
    }

    public static <T> ToString<T> toStringOmitIfAbsent(String name, Function<? super T, ?> getter) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(getter);
        return new ToString<T>(name, getter, true);
    }

    private ToString(String name, Function<? super T, ?> getter, boolean omitIfAbsent) {
        this.addBit(omitIfAbsent);
        this.names.add(name);
        this.getters.add(getter);
    }

    public ToString<T> thenToString(String name, Function<? super T, ?> getter) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(getter);
        this.addBit(false);
        this.names.add(name);
        this.getters.add(getter);
        return this;
    }

    public ToString<T> thenToStringOmitIfAbsent(String name, Function<? super T, ?> getter) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(getter);
        this.addBit(true);
        this.names.add(name);
        this.getters.add(getter);
        return this;
    }

    public String toString(T target) {
        return this.toString(target, value -> "" + value);
    }

    public String toString(T target, Function<Object, String> valueToStringFunction) {
        if (valueToStringFunction == null) {
            return this.toString(target);
        }
        if (target == null) {
            return "null";
        }
        Objects.requireNonNull(valueToStringFunction);
        int[] index = new int[]{-1};
        return String.format("%s{%s}", target.getClass().getSimpleName(), this.getters.stream().peek(__ -> {
            index[0] = index[0] + 1;
        }).map(getter -> getter.apply(target)).filter(value -> value != null || !this.omitIfAbsent.get(index[0])).map(valueToStringFunction).map(valueLiteral -> this.names.get(index[0]) + "=" + valueLiteral).collect(Collectors.joining(", ")));
    }

    private void addBit(boolean bit) {
        int index = this.names.size();
        if (bit) {
            this.omitIfAbsent.set(index);
        } else {
            this.omitIfAbsent.clear(index);
        }
    }
}

