/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.isis.applib.util.TitleBufferException;
import org.apache.isis.commons.internal._Constants;

public class TitleBuffer {
    private static final String SPACE = " ";
    private final StringBuilder title = new StringBuilder();

    public static boolean isEmpty(Object object) {
        String title = TitleBuffer.titleFor(object);
        return TitleBuffer.isEmpty(title);
    }

    private static String titleFor(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return object.toString();
        }
        try {
            Method method = object.getClass().getMethod("title", _Constants.emptyClasses);
            return (String)method.invoke(object, _Constants.emptyObjects);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new TitleBufferException(e);
        }
        catch (NoSuchMethodException e) {
            return object.toString();
        }
    }

    public static boolean isEmpty(String text) {
        return text == null || text.equals("");
    }

    public TitleBuffer() {
    }

    public TitleBuffer(Object object) {
        this();
        this.concat(object);
    }

    public TitleBuffer(Object object, String defaultTitle) {
        this();
        String title = TitleBuffer.titleFor(object);
        if (TitleBuffer.isEmpty(title)) {
            this.concat(defaultTitle);
        } else {
            this.concat(title);
        }
    }

    public TitleBuffer(String text) {
        this();
        this.concat(text);
    }

    public TitleBuffer append(int number) {
        this.append(String.valueOf(number));
        return this;
    }

    public TitleBuffer append(Object object) {
        String title = TitleBuffer.titleFor(object);
        if (!TitleBuffer.isEmpty(title)) {
            this.appendWithSpace(title);
        }
        return this;
    }

    public TitleBuffer append(Object object, String defaultValue) {
        String title = TitleBuffer.titleFor(object);
        if (!TitleBuffer.isEmpty(title)) {
            this.appendWithSpace(title);
        } else {
            this.appendWithSpace(defaultValue);
        }
        return this;
    }

    public TitleBuffer append(String text) {
        if (!TitleBuffer.isEmpty(text)) {
            this.appendWithSpace(text);
        }
        return this;
    }

    public TitleBuffer append(String joiner, Object object) {
        String title = TitleBuffer.titleFor(object);
        if (!TitleBuffer.isEmpty(title)) {
            this.appendJoiner(joiner);
            this.appendWithSpace(title);
        }
        return this;
    }

    public TitleBuffer append(String joiner, Object object, String defaultTitle) {
        this.appendJoiner(joiner);
        String title = TitleBuffer.titleFor(object);
        if (!TitleBuffer.isEmpty(title)) {
            this.appendWithSpace(title);
        } else {
            this.appendWithSpace(defaultTitle);
        }
        return this;
    }

    public TitleBuffer append(String joiner, String text) {
        if (!TitleBuffer.isEmpty(text)) {
            this.appendJoiner(joiner);
            this.appendWithSpace(text);
        }
        return this;
    }

    private void appendJoiner(String joiner) {
        if (this.title.length() > 0) {
            this.title.append(joiner);
        }
    }

    public TitleBuffer appendSpace() {
        if (this.title.length() > 0) {
            this.title.append(SPACE);
        }
        return this;
    }

    private void appendWithSpace(Object object) {
        this.appendSpace();
        this.title.append(TitleBuffer.titleFor(object));
    }

    public final TitleBuffer concat(Object object) {
        this.concat(object, "");
        return this;
    }

    public final TitleBuffer concat(Object object, String defaultValue) {
        String title = TitleBuffer.titleFor(object);
        if (TitleBuffer.isEmpty(title)) {
            this.title.append(defaultValue);
        } else {
            this.title.append(title);
        }
        return this;
    }

    public final TitleBuffer concat(String text) {
        this.title.append(text);
        return this;
    }

    public TitleBuffer concat(String joiner, String text) {
        if (!TitleBuffer.isEmpty(text)) {
            this.appendJoiner(joiner);
            this.title.append(text);
        }
        return this;
    }

    public final TitleBuffer concat(String joiner, Object object) {
        String title = TitleBuffer.titleFor(object);
        if (!TitleBuffer.isEmpty(title)) {
            this.appendJoiner(joiner);
            this.concat(title, "");
        }
        return this;
    }

    public final TitleBuffer concat(String joiner, Object object, String defaultValue) {
        String title = TitleBuffer.titleFor(object);
        if (TitleBuffer.isEmpty(title)) {
            this.appendJoiner(joiner);
            this.title.append(defaultValue);
        } else {
            this.appendJoiner(joiner);
            this.title.append(title);
        }
        return this;
    }

    public String toString() {
        return this.title.toString();
    }

    public TitleBuffer truncate(int noWords) {
        int pos;
        if (noWords < 1) {
            throw new IllegalArgumentException("Truncation must be to one or more words");
        }
        int spaces = 0;
        for (pos = 0; pos < this.title.length() && spaces < noWords; ++pos) {
            if (this.title.charAt(pos) != ' ') continue;
            ++spaces;
        }
        if (pos < this.title.length()) {
            this.title.setLength(pos - 1);
            this.title.append("...");
        }
        return this;
    }
}

