/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.collections._Lists;

public class ReasonBuffer2 {
    private final Mode mode;
    private final String prefix;
    private final List<LazyReason> lazyReasons = _Lists.newArrayList();

    public static Builder builder() {
        return new Builder();
    }

    public static ReasonBuffer2 forAll() {
        return ReasonBuffer2.builder().build();
    }

    public static ReasonBuffer2 forSingle() {
        return ReasonBuffer2.builder().mode(Mode.SINGLE).build();
    }

    public static ReasonBuffer2 forAll(String prefix) {
        return ReasonBuffer2.builder().prefix(prefix).build();
    }

    public static ReasonBuffer2 forSingle(String prefix) {
        return ReasonBuffer2.builder().prefix(prefix).mode(Mode.SINGLE).build();
    }

    private ReasonBuffer2(Mode mode, String prefix) {
        this.prefix = prefix;
        this.mode = mode != null ? mode : Mode.ALL;
    }

    public ReasonBuffer2 append(LazyReason lazyReason) {
        this.lazyReasons.add(lazyReason);
        return this;
    }

    public void appendIfNotPresent(Optional<?> optional, String reason) {
        this.append(() -> !optional.isPresent(), reason);
    }

    public ReasonBuffer2 append(String reason) {
        this.append(true, reason);
        return this;
    }

    public ReasonBuffer2 append(boolean condition, String reason) {
        this.lazyReasons.add(ConditionAndReason.create(() -> condition, reason));
        return this;
    }

    public ReasonBuffer2 append(Condition condition, String reason) {
        this.lazyReasons.add(ConditionAndReason.create(condition, reason));
        return this;
    }

    public String getReason() {
        Optional<LazyReason> anyReasons = this.lazyReasons.stream().filter(Objects::nonNull).findAny();
        if (!anyReasons.isPresent()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String reasons = this.appendReason(buf);
        return reasons.isEmpty() ? null : reasons;
    }

    public String appendReason(StringBuilder buf) {
        List nonNullLazyReasons = this.lazyReasons.stream().filter(Objects::nonNull).collect(Collectors.toList());
        int numReasons = 0;
        for (LazyReason lazyReason : nonNullLazyReasons) {
            String reasonIfAny = lazyReason.evaluate();
            if (reasonIfAny == null) continue;
            if (numReasons > 0) {
                buf.append("; ");
            }
            buf.append(reasonIfAny);
            ++numReasons;
            if (this.mode != Mode.SINGLE) continue;
            break;
        }
        if (this.prefix != null && numReasons > 0) {
            buf.insert(0, " ");
            if (numReasons != 1) {
                buf.insert(0, ":");
            }
            buf.insert(0, this.prefix);
        }
        return buf.toString();
    }

    public ReasonBuffer2 plus(ReasonBuffer2 other) {
        this.lazyReasons.addAll(other.lazyReasons);
        return this;
    }

    public static class Builder {
        private Mode mode;
        private String prefix;

        Builder() {
        }

        public Builder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ReasonBuffer2 build() {
            return new ReasonBuffer2(this.mode, this.prefix);
        }

        public String toString() {
            return "ReasonBuffer2.Builder(mode=" + this.mode + ", prefix=" + this.prefix + ")";
        }
    }

    public static enum Mode {
        ALL,
        SINGLE;

    }

    private static class ConditionAndReason
    implements LazyReason {
        private final Condition condition;
        private final String reason;

        public static ConditionAndReason create(Condition condition, String reason) {
            return reason != null ? new ConditionAndReason(condition, reason) : null;
        }

        private ConditionAndReason(Condition condition, String reason) {
            this.condition = condition;
            this.reason = reason;
        }

        @Override
        public String evaluate() {
            return this.condition.evaluate() ? this.reason : null;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static interface LazyReason {
        public String evaluate();
    }

    public static interface Condition {
        public boolean evaluate();
    }
}

