/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import org.apache.isis.applib.util.Equality;
import org.apache.isis.applib.util.Hashing;
import org.apache.isis.applib.util.ObjectContract_Empty;
import org.apache.isis.applib.util.ObjectContract_Parser;
import org.apache.isis.applib.util.ToString;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ObjectContracts {
    private static final Logger log = LogManager.getLogger(ObjectContracts.class);

    private ObjectContracts() {
    }

    public static <T> ToString<T> toString(String name, Function<T, ?> getter) {
        return ToString.toString(name, getter);
    }

    public static <T> Equality<T> checkEquals(Function<T, ?> getter) {
        return Equality.checkEquals(getter);
    }

    public static <T> Hashing<T> hashing(Function<T, ?> getter) {
        return Hashing.hashing(getter);
    }

    public static <T> ObjectContract<T> contract(Class<T> objectClass) {
        return ObjectContract.empty(objectClass);
    }

    public static <T> ObjectContract<T> parse(Class<T> target, String propertyNames) {
        return ObjectContract_Parser.parse(target, propertyNames);
    }

    @Deprecated
    public static <T> String toString(T obj, String propertyNames) {
        Objects.requireNonNull(obj, "obj required, otherwise undecidable");
        return ObjectContracts.parse((Class)_Casts.uncheckedCast(obj.getClass()), propertyNames).toString(obj);
    }

    @Deprecated
    public static <T> boolean equals(T obj, Object other, String propertyNames) {
        if (obj == null && other == null) {
            if (log.isWarnEnabled()) {
                log.warn("potential misuse of <T> ObjectContracts::equals(T obj, Object other, String propertyNames). First argument is not expected to be null!");
            }
            return true;
        }
        Objects.requireNonNull(obj, "obj required, otherwise undecidable");
        return ObjectContracts.parse((Class)_Casts.uncheckedCast(obj.getClass()), propertyNames).equals(obj, other);
    }

    @Deprecated
    public static int hashCode(Object obj, String propertyNames) {
        Objects.requireNonNull(obj, "obj required, otherwise undecidable");
        return ObjectContracts.parse((Class)_Casts.uncheckedCast(obj.getClass()), propertyNames).hashCode(obj);
    }

    @Deprecated
    public static <T> int compare(T obj, T other, String propertyNames) {
        Objects.requireNonNull(obj, "obj required, otherwise undecidable");
        return ObjectContracts.parse((Class)_Casts.uncheckedCast(obj.getClass()), propertyNames).compare(obj, other);
    }

    public static interface ToStringEvaluator {
        public boolean canEvaluate(Object var1);

        public String evaluate(Object var1);

        public static Function<Object, String> combineToFunction(ToStringEvaluator ... evaluators) {
            return value -> {
                if (value == null) {
                    return null;
                }
                if (!_NullSafe.isEmpty((Object[])evaluators)) {
                    for (ToStringEvaluator evaluator : evaluators) {
                        if (!evaluator.canEvaluate(value)) continue;
                        return evaluator.evaluate(value);
                    }
                }
                return value.toString();
            };
        }
    }

    public static interface ObjectContract<T> {
        public int compare(T var1, T var2);

        public boolean equals(T var1, Object var2);

        public int hashCode(T var1);

        public String toString(T var1);

        public ObjectContract<T> withValueToStringFunction(Function<Object, String> var1);

        public <U> ObjectContract<T> thenUse(String var1, Function<? super T, ? extends U> var2, Comparator<? super U> var3);

        default public <U extends Comparable<? super U>> ObjectContract<T> thenUse(String propertyLabel, Function<? super T, ? extends U> getter) {
            return this.thenUse(propertyLabel, getter, Comparator.naturalOrder());
        }

        public static <T> ObjectContract<T> empty(Class<T> objectClass) {
            return new ObjectContract_Empty<T>(objectClass);
        }
    }
}

