/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.commons.internal._Constants;
import org.apache.isis.commons.internal.base._Strings;
import org.springframework.lang.Nullable;

class ObjectContract_Parser<T> {
    ObjectContract_Parser() {
    }

    public static <T> ObjectContracts.ObjectContract<T> parse(Class<T> cls, @Nullable String propertyNames) {
        Objects.requireNonNull(cls);
        List clauses = _Strings.splitThenStream((String)propertyNames, (String)",").map(String::trim).filter(p -> !p.isEmpty()).map(p -> Clause.parse(cls, p)).collect(Collectors.toList());
        ObjectContracts.ObjectContract<Object> contract = ObjectContracts.ObjectContract.empty(cls);
        if (clauses.isEmpty()) {
            return contract;
        }
        for (Clause clause : clauses) {
            Function<Object, Object> valueExtractor = x -> clause.extractValue(x);
            contract = contract.thenUse(clause.propertyName, valueExtractor, clause.direction.getOrdering());
        }
        return contract;
    }

    private static class Clause<T> {
        private static Pattern pattern = Pattern.compile("\\W*(\\w+)\\W*(asc|asc nullsFirst|asc nullsLast|desc|desc nullsFirst|desc nullsLast)?\\W*");
        private final Class<T> objectClass;
        private final String propertyName;
        private final Direction direction;
        private final Method getterMethod;

        private static <X> Clause<X> parse(Class<X> cls, String input) {
            Matcher matcher = pattern.matcher(input);
            if (!matcher.matches()) {
                return null;
            }
            return new Clause<X>(cls, matcher.group(1), Direction.valueOfElseAsc(matcher.group(2)));
        }

        private Clause(Class<T> cls, String propertyName, Direction direction) {
            this.objectClass = cls;
            this.propertyName = propertyName;
            this.direction = direction;
            this.getterMethod = this.findGetter();
        }

        public Method findGetter() {
            String methodNameSuffix = _Strings.capitalize((String)this.propertyName);
            String getMethodName = "get" + methodNameSuffix;
            try {
                return this.objectClass.getMethod(getMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                String isMethodName = "is" + methodNameSuffix;
                try {
                    return this.objectClass.getMethod(isMethodName, new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    throw new IllegalArgumentException("No such method ' " + getMethodName + "' or '" + isMethodName + "'", e);
                }
            }
        }

        public Object extractValue(T obj) {
            try {
                return this.getterMethod.invoke(obj, _Constants.emptyObjects);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private static enum Direction {
            ASC{

                @Override
                public Comparator<Comparable<?>> getOrdering() {
                    return Comparator.nullsFirst(Comparator.naturalOrder());
                }
            }
            ,
            ASC_NULLS_LAST{

                @Override
                public Comparator<Comparable<?>> getOrdering() {
                    return Comparator.nullsLast(Comparator.naturalOrder());
                }
            }
            ,
            DESC{

                @Override
                public Comparator<Comparable<?>> getOrdering() {
                    return ASC_NULLS_LAST.getOrdering().reversed();
                }
            }
            ,
            DESC_NULLS_LAST{

                @Override
                public Comparator<Comparable<?>> getOrdering() {
                    return ASC.getOrdering().reversed();
                }
            };


            public abstract Comparator<Comparable<?>> getOrdering();

            public static Direction valueOfElseAsc(String str) {
                if ("asc".equals(str)) {
                    return ASC;
                }
                if ("asc nullsFirst".equals(str)) {
                    return ASC;
                }
                if ("asc nullsLast".equals(str)) {
                    return ASC_NULLS_LAST;
                }
                if ("desc".equals(str)) {
                    return DESC;
                }
                if ("desc nullsFirst".equals(str)) {
                    return DESC;
                }
                if ("desc nullsLast".equals(str)) {
                    return DESC_NULLS_LAST;
                }
                return ASC;
            }
        }
    }
}

