/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.util.Comparator;
import java.util.function.Function;
import org.apache.isis.applib.util.Equality;
import org.apache.isis.applib.util.Hashing;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.applib.util.ToString;

class ObjectContract_Impl<T>
implements ObjectContracts.ObjectContract<T> {
    private final Equality<T> equality;
    private final Hashing<T> hashing;
    private final ToString<T> toString;
    private final Comparator<T> comparator;
    Function<Object, String> valueToStringFunction;

    ObjectContract_Impl(Equality<T> equality, Hashing<T> hashing, ToString<T> toString, Comparator<T> comparator) {
        this.equality = equality;
        this.hashing = hashing;
        this.toString = toString;
        this.comparator = comparator;
    }

    @Override
    public int compare(T obj, T other) {
        return this.comparator.compare(obj, other);
    }

    @Override
    public boolean equals(T obj, Object other) {
        return this.equality.equals(obj, other);
    }

    @Override
    public int hashCode(T obj) {
        return this.hashing.hashCode(obj);
    }

    @Override
    public String toString(T obj) {
        return this.toString.toString(obj, this.valueToStringFunction);
    }

    @Override
    public ObjectContracts.ObjectContract<T> withValueToStringFunction(Function<Object, String> valueToStringFunction) {
        this.valueToStringFunction = valueToStringFunction;
        return this;
    }

    @Override
    public <U> ObjectContracts.ObjectContract<T> thenUse(String propertyLabel, Function<? super T, ? extends U> getter, Comparator<? super U> valueComparator) {
        ObjectContract_Impl<? super T> contract = new ObjectContract_Impl<T>(this.equality.thenCheckEquals(getter), this.hashing.thenHashing(getter), this.toString.thenToString(propertyLabel, getter), this.comparator.thenComparing(Comparator.comparing(getter, valueComparator)));
        contract.valueToStringFunction = this.valueToStringFunction;
        return contract;
    }
}

