/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.util.Comparator;
import java.util.function.Function;
import org.apache.isis.applib.util.Equality;
import org.apache.isis.applib.util.Hashing;
import org.apache.isis.applib.util.ObjectContract_Impl;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.applib.util.ToString;

class ObjectContract_Empty<T>
implements ObjectContracts.ObjectContract<T> {
    private static final String UNDEFINED_CONTRACT = "object's contract is not defined (empty)";
    private Function<Object, String> valueToStringFunction;

    public ObjectContract_Empty(Class<T> objectClass) {
    }

    @Override
    public int compare(T obj, T other) {
        throw ObjectContract_Empty.undefined();
    }

    @Override
    public boolean equals(T obj, Object other) {
        throw ObjectContract_Empty.undefined();
    }

    @Override
    public int hashCode(T obj) {
        throw ObjectContract_Empty.undefined();
    }

    @Override
    public String toString(T obj) {
        return UNDEFINED_CONTRACT;
    }

    @Override
    public ObjectContracts.ObjectContract<T> withValueToStringFunction(Function<Object, String> valueToStringFunction) {
        this.valueToStringFunction = valueToStringFunction;
        return this;
    }

    @Override
    public <U> ObjectContracts.ObjectContract<T> thenUse(String propertyLabel, Function<? super T, ? extends U> getter, Comparator<? super U> valueComparator) {
        ObjectContract_Impl<? super T> contract = new ObjectContract_Impl<T>(Equality.checkEquals(getter), Hashing.hashing(getter), ToString.toString(propertyLabel, getter), Comparator.comparing(getter, valueComparator));
        contract.valueToStringFunction = this.valueToStringFunction;
        return contract;
    }

    private static final IllegalArgumentException undefined() {
        return new IllegalArgumentException(UNDEFINED_CONTRACT);
    }
}

