/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import lombok.NonNull;
import org.apache.isis.commons.functional.Try;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.commons.internal.resources._Xml;

public final class JaxbUtil {
    private static <T> T _fromXml(@NonNull Reader reader, @NonNull Class<T> dtoClass) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (dtoClass == null) {
            throw new NullPointerException("dtoClass is marked non-null but is null");
        }
        return (T)_Xml._readXml(dtoClass, (Reader)reader, (_Xml.ReadOptions)_Xml.ReadOptions.builder().useContextCache(true).build());
    }

    public static <T> Try<T> fromXml(@NonNull Reader reader, @NonNull Class<T> dtoClass) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (dtoClass == null) {
            throw new NullPointerException("dtoClass is marked non-null but is null");
        }
        return Try.call(() -> JaxbUtil._fromXml(reader, dtoClass));
    }

    private static <T> T _fromXml(@NonNull Class<?> contextClass, @NonNull String resourceName, @NonNull Class<T> dtoClass) throws IOException {
        if (contextClass == null) {
            throw new NullPointerException("contextClass is marked non-null but is null");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        if (dtoClass == null) {
            throw new NullPointerException("dtoClass is marked non-null but is null");
        }
        String xmlString = _Resources.loadAsStringUtf8(contextClass, (String)resourceName);
        return JaxbUtil._fromXml(new StringReader(xmlString), dtoClass);
    }

    public static <T> Try<T> fromXml(@NonNull Class<?> contextClass, @NonNull String resourceName, @NonNull Class<T> dtoClass) throws IOException {
        if (contextClass == null) {
            throw new NullPointerException("contextClass is marked non-null but is null");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        if (dtoClass == null) {
            throw new NullPointerException("dtoClass is marked non-null but is null");
        }
        return Try.call(() -> JaxbUtil._fromXml(contextClass, resourceName, dtoClass));
    }

    public static Try<String> toXml(@NonNull Object dto) {
        if (dto == null) {
            throw new NullPointerException("dto is marked non-null but is null");
        }
        return Try.call(() -> {
            CharArrayWriter caw = new CharArrayWriter();
            JaxbUtil.toXml(dto, caw);
            return caw.toString();
        });
    }

    public static <T> void toXml(@NonNull T dto, @NonNull Writer writer) throws JAXBException {
        if (dto == null) {
            throw new NullPointerException("dto is marked non-null but is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        _Xml.writeXml(dto, (Writer)writer, (_Xml.WriteOptions)_Xml.WriteOptions.builder().useContextCache(true).formattedOutput(true).build());
    }

    public static JAXBContext jaxbContextFor(@NonNull Class<?> dtoClass) {
        if (dtoClass == null) {
            throw new NullPointerException("dtoClass is marked non-null but is null");
        }
        boolean useCache = true;
        return _Xml.jaxbContextFor(dtoClass, (boolean)true);
    }

    private JaxbUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

