/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.isis.commons.internal.collections._Lists;

public class Hashing<T> {
    private final List<Function<? super T, ?>> getters = _Lists.newArrayList();

    public static <T> Hashing<T> hashing(Function<? super T, ?> getter) {
        return new Hashing<T>(getter);
    }

    private Hashing(Function<? super T, ?> getter) {
        this.getters.add(getter);
    }

    public Hashing<T> thenHashing(Function<? super T, ?> getter) {
        Objects.requireNonNull(getter);
        this.getters.add(getter);
        return this;
    }

    public int hashCode(T object) {
        if (object == null) {
            return 0;
        }
        int result = 1;
        for (Function<T, ?> getter : this.getters) {
            Object element = getter.apply(object);
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }
}

