/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Lists;

public class Equality<T> {
    private final List<Function<? super T, ?>> getters = _Lists.newArrayList();

    public static <T> Equality<T> checkEquals(Function<? super T, ?> getter) {
        Objects.requireNonNull(getter);
        return new Equality<T>(getter);
    }

    private Equality(Function<? super T, ?> getter) {
        this.getters.add(getter);
    }

    public Equality<T> thenCheckEquals(Function<? super T, ?> getter) {
        Objects.requireNonNull(getter);
        this.getters.add(getter);
        return this;
    }

    public boolean equals(T target, Object other) {
        if (target == null && other == null) {
            return true;
        }
        if (target == null || other == null) {
            return false;
        }
        if (target.getClass() != other.getClass()) {
            return false;
        }
        Object o = _Casts.uncheckedCast((Object)other);
        for (Function<Object, ?> function : this.getters) {
            if (Objects.equals(function.apply(target), function.apply(o))) continue;
            return false;
        }
        return true;
    }
}

