/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._Strings;
import org.springframework.lang.Nullable;

public final class Enums {
    public static String getFriendlyNameOf(Enum<?> anEnum) {
        return Enums.getFriendlyNameOf(anEnum.name());
    }

    public static String getFriendlyNameOf(String anEnumName) {
        return _Strings.splitThenStream((String)anEnumName, (String)"_").map(_Strings::lower).map(_Strings::capitalize).collect(Collectors.joining(" "));
    }

    public static String getEnumNameFromFriendly(String anEnumFriendlyName) {
        return _Strings.splitThenStream((String)anEnumFriendlyName, (String)" ").map(_Strings::upper).collect(Collectors.joining("_"));
    }

    public static String enumToHttpHeader(Enum<?> anEnum) {
        return Enums.enumNameToHttpHeader(anEnum.name());
    }

    public static String enumNameToHttpHeader(String name) {
        StringBuilder builder = new StringBuilder();
        boolean nextUpper = true;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                nextUpper = true;
                builder.append("-");
                continue;
            }
            builder.append(nextUpper ? c : Character.toLowerCase(c));
            nextUpper = false;
        }
        return builder.toString();
    }

    public static String enumToCamelCase(Enum<?> anEnum) {
        String name = anEnum.name();
        StringBuilder builder = new StringBuilder();
        boolean nextUpper = false;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                nextUpper = true;
                continue;
            }
            builder.append(nextUpper ? c : Character.toLowerCase(c));
            nextUpper = false;
        }
        return builder.toString();
    }

    public static <T extends Enum<?>> Optional<T> parseFriendlyName(Class<T> correspondingClass, @Nullable String text) {
        Enum[] enumConstants;
        String input = _Strings.blankToNullOrTrim((String)text);
        if (input == null) {
            return Optional.empty();
        }
        for (Enum enumConstant : enumConstants = (Enum[])correspondingClass.getEnumConstants()) {
            if (!Enums.getFriendlyNameOf(enumConstant).equalsIgnoreCase(input)) continue;
            return Optional.of(enumConstant);
        }
        for (Enum enumConstant : enumConstants) {
            if (!enumConstant.toString().equalsIgnoreCase(input)) continue;
            return Optional.of(enumConstant);
        }
        return Optional.empty();
    }

    private Enums() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

