/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.spec;

import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.spec.Specification;
import org.apache.isis.applib.util.ReasonBuffer;

public abstract class SpecificationOr
implements Specification {
    private final Specification[] specifications;

    public SpecificationOr(Specification ... specifications) {
        this.specifications = specifications;
    }

    @Override
    @Programmatic
    public String satisfies(Object obj) {
        ReasonBuffer buf = new ReasonBuffer();
        for (Specification specification : this.specifications) {
            String reasonNotSatisfiedIfAny = specification.satisfies(obj);
            if (reasonNotSatisfiedIfAny == null) {
                return null;
            }
            buf.append(reasonNotSatisfiedIfAny);
        }
        return buf.getReason();
    }
}

