/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.spec;

import java.lang.reflect.Method;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.spec.Specification2;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.reflection._ClassCache;

public abstract class AbstractSpecification2<T>
implements Specification2 {
    private final Class<?> expectedType = AbstractSpecification2.findExpectedType(this.getClass());
    private final Nullability nullability;
    private final TypeChecking typeChecking;

    private static Class<?> findExpectedType(Class<?> fromClass) {
        _ClassCache classCache = _ClassCache.getInstance();
        for (Class<?> c = fromClass; c != Object.class; c = c.getSuperclass()) {
            Method methodFound = classCache.streamDeclaredMethods(c).filter(AbstractSpecification2::isSatisfiesTranslatableSafelyMethod).findFirst().orElse(null);
            if (methodFound == null) continue;
            return methodFound.getParameterTypes()[0];
        }
        throw new Error("Cannot determine correct type for satisfiesSafely() method.");
    }

    private static boolean isSatisfiesTranslatableSafelyMethod(Method method) {
        return method.getName().equals("satisfiesTranslatableSafely") && method.getParameterTypes().length == 1 && !method.isSynthetic();
    }

    protected AbstractSpecification2() {
        this(Nullability.IGNORE_IF_NULL, TypeChecking.IGNORE_INCORRECT_TYPE);
    }

    protected AbstractSpecification2(Nullability nullability, TypeChecking typeChecking) {
        this.nullability = nullability;
        this.typeChecking = typeChecking;
    }

    @Override
    @Programmatic
    public final String satisfies(Object obj) {
        return null;
    }

    @Override
    @Programmatic
    public TranslatableString satisfiesTranslatable(Object obj) {
        if (obj == null) {
            return this.nullability == Nullability.IGNORE_IF_NULL ? null : TranslatableString.tr("Cannot be null", new Object[0]);
        }
        if (!this.expectedType.isInstance(obj)) {
            return this.typeChecking == TypeChecking.IGNORE_INCORRECT_TYPE ? null : TranslatableString.tr("Incorrect type", new Object[0]);
        }
        Object objAsT = _Casts.uncheckedCast((Object)obj);
        return this.satisfiesTranslatableSafely(objAsT);
    }

    @Programmatic
    public abstract TranslatableString satisfiesTranslatableSafely(T var1);

    public static enum Nullability {
        ENSURE_NOT_NULL,
        IGNORE_IF_NULL;

    }

    public static enum TypeChecking {
        ENSURE_CORRECT_TYPE,
        IGNORE_INCORRECT_TYPE;

    }
}

