/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.xactn;

import java.util.concurrent.Callable;
import org.apache.isis.commons.functional.ThrowingRunnable;
import org.apache.isis.commons.functional.Try;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public interface TransactionalProcessor {
    public <T> Try<T> callTransactional(TransactionDefinition var1, Callable<T> var2);

    default public Try<Void> runTransactional(TransactionDefinition def, ThrowingRunnable runnable) {
        return this.callTransactional(def, ThrowingRunnable.toCallable((ThrowingRunnable)runnable));
    }

    default public <T> Try<T> callTransactional(Propagation propagation, Callable<T> callable) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(propagation.value());
        return this.callTransactional((TransactionDefinition)def, callable);
    }

    default public Try<Void> runTransactional(Propagation propagation, ThrowingRunnable runnable) {
        return this.callTransactional(propagation, ThrowingRunnable.toCallable((ThrowingRunnable)runnable));
    }

    default public <T> Try<T> callWithinCurrentTransactionElseCreateNew(Callable<T> callable) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(0);
        return this.callTransactional((TransactionDefinition)def, callable);
    }

    default public Try<Void> runWithinCurrentTransactionElseCreateNew(ThrowingRunnable runnable) {
        return this.callWithinCurrentTransactionElseCreateNew(ThrowingRunnable.toCallable((ThrowingRunnable)runnable));
    }
}

