/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.xactn;

import java.util.UUID;
import org.apache.isis.applib.mixins.system.HasInteractionIdAndSequence;

public final class TransactionId
implements HasInteractionIdAndSequence {
    private final UUID interactionId;
    private final int sequence;
    private final String context;
    private static final TransactionId EMPTY = TransactionId.of(UUID.fromString("0000-00-00-00-000000"), 0, "");

    public static TransactionId empty() {
        return EMPTY;
    }

    private TransactionId(UUID interactionId, int sequence, String context) {
        this.interactionId = interactionId;
        this.sequence = sequence;
        this.context = context;
    }

    public static TransactionId of(UUID interactionId, int sequence, String context) {
        return new TransactionId(interactionId, sequence, context);
    }

    @Override
    public UUID getInteractionId() {
        return this.interactionId;
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    public String getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionId)) {
            return false;
        }
        TransactionId other = (TransactionId)o;
        if (this.getSequence() != other.getSequence()) {
            return false;
        }
        UUID this$interactionId = this.getInteractionId();
        UUID other$interactionId = other.getInteractionId();
        if (this$interactionId == null ? other$interactionId != null : !((Object)this$interactionId).equals(other$interactionId)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSequence();
        UUID $interactionId = this.getInteractionId();
        result = result * 59 + ($interactionId == null ? 43 : ((Object)$interactionId).hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }

    public String toString() {
        return "TransactionId(interactionId=" + this.getInteractionId() + ", sequence=" + this.getSequence() + ", context=" + this.getContext() + ")";
    }
}

