/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.wrapper.events;

import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.events.EventObjectBase;
import org.apache.isis.commons.collections.Can;

public abstract class InteractionEvent
extends EventObjectBase<Object> {
    private final Identifier identifier;
    private String reason;
    private Class<?> advisorClass;

    public InteractionEvent(Object source, Identifier identifier) {
        super(source);
        this.identifier = identifier;
    }

    @Override
    public Object getSource() {
        return super.getSource();
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String getClassName() {
        return this.identifier.getClassName();
    }

    public String getClassNaturalName() {
        return this.identifier.getClassNaturalName();
    }

    public String getMemberName() {
        return this.identifier.getMemberLogicalName();
    }

    public String getMemberNaturalName() {
        return this.identifier.getMemberNaturalName();
    }

    public Can<String> getMemberParameterNames() {
        return this.identifier.getMemberParameterClassNames();
    }

    public Can<String> getMemberParameterNaturalNames() {
        return this.identifier.getMemberParameterClassNaturalNames();
    }

    public String getReason() {
        return this.reason;
    }

    public String getReasonMessage() {
        if (this.getIdentifier() != null) {
            return String.format("Reason: %s. Identifier: %s", this.getReason(), this.getIdentifier());
        }
        return String.format("Reason: %s", this.getReason());
    }

    public Class<?> getAdvisorClass() {
        return this.advisorClass;
    }

    public void advised(String reason, Class<?> advisorClass) {
        this.reason = reason;
        this.advisorClass = advisorClass;
    }

    public boolean isVeto() {
        return this.getReason() != null && this.getReason().length() > 0;
    }
}

