/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.wrapper.control;

import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.wrapper.control.ExceptionHandler;
import org.apache.isis.applib.services.wrapper.control.ExecutionMode;
import org.apache.isis.commons.collections.ImmutableEnumSet;
import org.apache.isis.commons.internal.base._Casts;

public class ControlAbstract<T extends ControlAbstract<T>> {
    private Method method;
    private Bookmark bookmark;
    private boolean checkRules = true;
    private ExceptionHandler exceptionHandler;

    protected ControlAbstract() {
    }

    public T withCheckRules() {
        this.checkRules = true;
        return (T)((ControlAbstract)_Casts.uncheckedCast((Object)this));
    }

    public T withSkipRules() {
        this.checkRules = false;
        return (T)((ControlAbstract)_Casts.uncheckedCast((Object)this));
    }

    public Optional<ExceptionHandler> getExceptionHandler() {
        return Optional.ofNullable(this.exceptionHandler);
    }

    public T with(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return (T)((ControlAbstract)_Casts.uncheckedCast((Object)this));
    }

    public ImmutableEnumSet<ExecutionMode> getExecutionModes() {
        EnumSet<ExecutionMode> modes = EnumSet.noneOf(ExecutionMode.class);
        if (!this.checkRules) {
            modes.add(ExecutionMode.SKIP_RULE_VALIDATION);
        }
        return ImmutableEnumSet.from(modes);
    }

    Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    Bookmark getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(Bookmark bookmark) {
        this.bookmark = bookmark;
    }
}

