/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.wrapper.control;

import java.time.ZoneId;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.isis.applib.clock.VirtualClock;
import org.apache.isis.applib.services.user.UserMemento;
import org.apache.isis.applib.services.wrapper.control.ControlAbstract;
import org.apache.isis.applib.services.wrapper.control.ExceptionHandler;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncControl<R>
extends ControlAbstract<AsyncControl<R>> {
    private static final Logger log = LogManager.getLogger(AsyncControl.class);
    private final Class<R> returnType;
    @NonNull
    private ExecutorService executorService = ForkJoinPool.commonPool();
    private VirtualClock clock;
    private Locale locale;
    private ZoneId timeZone;
    private UserMemento user;
    private Future<R> future;

    public static AsyncControl<Void> returningVoid() {
        return new AsyncControl<Void>(Void.class);
    }

    public static <X> AsyncControl<X> returning(Class<X> cls) {
        return new AsyncControl<X>(cls);
    }

    private AsyncControl(Class<R> returnType) {
        this.returnType = returnType;
        this.with((Exception exception) -> {
            log.error(this.logMessage(), (Throwable)exception);
            return null;
        });
    }

    @Override
    public AsyncControl<R> withSkipRules() {
        return (AsyncControl)super.withSkipRules();
    }

    @Override
    public AsyncControl<R> with(ExceptionHandler exceptionHandler) {
        return (AsyncControl)super.with(exceptionHandler);
    }

    public AsyncControl<R> with(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public AsyncControl<R> withClock(@NonNull VirtualClock clock) {
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        this.clock = clock;
        return this;
    }

    public AsyncControl<R> withLocale(@NonNull Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        this.locale = locale;
        return this;
    }

    public AsyncControl<R> withTimeZone(@NonNull ZoneId timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timeZone is marked non-null but is null");
        }
        this.timeZone = timeZone;
        return this;
    }

    public AsyncControl<R> withUser(@NonNull UserMemento user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.user = user;
        return this;
    }

    public void setFuture(Future<R> future) {
        this.future = future;
    }

    public R waitForResult(long timeout, TimeUnit unit) {
        _Assert.assertNotNull(this.future, () -> "detected call to waitForResult(..) before future was set");
        return this.future.get(timeout, unit);
    }

    private String logMessage() {
        StringBuilder buf = new StringBuilder("Failed to execute ");
        if (this.getMethod() != null) {
            buf.append(" ").append(this.getMethod().getName()).append(" ");
            if (this.getBookmark() != null) {
                buf.append(" on '").append(this.getBookmark().getLogicalTypeName()).append(":").append(this.getBookmark().getIdentifier()).append("'");
            }
        }
        return buf.toString();
    }

    public Class<R> getReturnType() {
        return this.returnType;
    }

    @NonNull
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public VirtualClock getClock() {
        return this.clock;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public UserMemento getUser() {
        return this.user;
    }

    public Future<R> getFuture() {
        return this.future;
    }
}

