/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.userui;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.user.UserMemento;
import org.apache.isis.applib.services.user.UserService;

@DomainService(nature=NatureOfService.VIEW)
@Named(value="isis.applib.UserMenu")
@DomainServiceLayout(menuBar=DomainServiceLayout.MenuBar.TERTIARY)
@Priority(value=0x1FFFFFFF)
public class UserMenu {
    static final String LOGICAL_TYPE_NAME = "isis.applib.UserMenu";
    final UserService userService;

    @Inject
    public UserMenu(UserService userService) {
        this.userService = userService;
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE)
    @ActionLayout(cssClassFa="fa-user", describedAs="Returns your user account details", sequence="100")
    public class me {
        @MemberSupport
        public UserMemento act() {
            return UserMenu.this.userService.currentUser().orElse(null);
        }

        @MemberSupport
        public String disableAct() {
            return UserMenu.this.userService.currentUser().isPresent() ? null : "Current user not available";
        }

        public class ActionDomainEvent
        extends org.apache.isis.applib.services.userui.UserMenu$ActionDomainEvent<me> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends IsisModuleApplib.ActionDomainEvent<T> {
    }
}

