/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.user;

import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.applib.services.iactnlayer.InteractionLayerTracker;
import org.apache.isis.applib.services.user.ImpersonatedUserHolder;
import org.apache.isis.applib.services.user.UserMemento;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.applib.UserService")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class UserService {
    static final String LOGICAL_TYPE_NAME = "isis.applib.UserService";
    public static final String NOBODY = "__isis_nobody";
    private final Provider<InteractionLayerTracker> iInteractionLayerTrackerProvider;
    private final List<ImpersonatedUserHolder> impersonatedUserHolders;

    public Optional<UserMemento> currentUser() {
        Optional<UserMemento> impersonatedUserIfAny = this.impersonatedUserIfAny();
        return impersonatedUserIfAny.isPresent() ? impersonatedUserIfAny : ((InteractionLayerTracker)this.iInteractionLayerTrackerProvider.get()).currentInteractionContext().map(InteractionContext::getUser);
    }

    public boolean isCurrentUserWithSystemPrivileges() {
        return this.currentUser().map(UserMemento::isSystem).orElse(false);
    }

    @Nullable
    public UserMemento getUser() {
        return this.currentUser().orElse(null);
    }

    public UserMemento currentUserElseFail() {
        return this.currentUser().orElseThrow(() -> _Exceptions.illegalState((String)"Current thread has no InteractionContext.", (Object[])new Object[0]));
    }

    public Optional<String> currentUserName() {
        return this.currentUser().map(UserMemento::getName);
    }

    public String currentUserNameElseNobody() {
        return this.currentUserName().orElse(NOBODY);
    }

    public boolean isImpersonating() {
        return this.impersonatedUserIfAny().isPresent();
    }

    public boolean supportsImpersonation() {
        return this.impersonatingHolder().isPresent();
    }

    private Optional<ImpersonatedUserHolder> impersonatingHolder() {
        for (ImpersonatedUserHolder impersonatedUserHolder : this.impersonatedUserHolders) {
            try {
                if (!impersonatedUserHolder.supportsImpersonation()) continue;
                return Optional.of(impersonatedUserHolder);
            }
            catch (Exception exception) {
            }
        }
        return Optional.empty();
    }

    public void impersonateUser(String userName, List<String> roles, String multiTenancyToken) {
        this.impersonatingHolder().ifPresent(x -> x.setUserMemento(UserMemento.ofNameAndRoleNames(userName, roles).withImpersonating(true).withMultiTenancyToken(multiTenancyToken)));
    }

    public void stopImpersonating() {
        this.impersonatingHolder().ifPresent(ImpersonatedUserHolder::clearUserMemento);
    }

    private Optional<UserMemento> impersonatedUserIfAny() {
        return this.impersonatingHolder().flatMap(ImpersonatedUserHolder::getUserMemento);
    }

    @Inject
    public UserService(Provider<InteractionLayerTracker> iInteractionLayerTrackerProvider, List<ImpersonatedUserHolder> impersonatedUserHolders) {
        this.iInteractionLayerTrackerProvider = iInteractionLayerTrackerProvider;
        this.impersonatedUserHolders = impersonatedUserHolders;
    }
}

