/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.user;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Named;
import lombok.NonNull;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Collection;
import org.apache.isis.applib.annotation.CollectionLayout;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.locale.UserLocale;
import org.apache.isis.applib.services.user.RoleMemento;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Strings;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;

@Named(value="isis.applib.UserMemento")
@DomainObject(nature=Nature.VIEW_MODEL)
@DomainObjectLayout(titleUiEvent=TitleUiEvent.class)
public final class UserMemento
implements Serializable {
    public static final String LOGICAL_TYPE_NAME = "isis.applib.UserMemento";
    public static final String AUTHORIZED_USER_ROLE = "org.apache.isis.security.AUTHORIZED_USER_ROLE";
    private static final long serialVersionUID = 7190090455587885367L;
    private static final UserMemento SYSTEM_USER = UserMemento.ofName("__system");
    @Property
    @PropertyLayout(fieldSetId="identity", sequence="1")
    @NonNull
    private final String name;
    @Property(optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="details", sequence="1")
    @Nullable
    private final String realName;
    @Property(optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="details", sequence="2")
    @Nullable
    private final URL avatarUrl;
    @Property(optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="regional", sequence="1")
    @Nullable
    private final Locale languageLocale;
    @Property(optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="regional", sequence="2")
    @Nullable
    private final Locale numberFormatLocale;
    @Property(optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="regional", sequence="3")
    @Nullable
    private final Locale timeFormatLocale;
    @Property
    @PropertyLayout(fieldSetId="security", sequence="1")
    @NonNull
    private final AuthenticationSource authenticationSource;
    @Property(optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="security", sequence="3")
    private final boolean impersonating;
    @Property(optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="security", sequence="2")
    @Nullable
    private final String multiTenancyToken;
    private static final String DEFAULT_AUTH_VALID_CODE = "";
    @Property(hidden=Where.EVERYWHERE)
    @NonNull
    private final String authenticationCode;
    private final Can<RoleMemento> roles;

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    public static UserMemento system() {
        return SYSTEM_USER;
    }

    public static UserMemento ofName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return UserMemento.builderWithDefaults(name).roles((Can<RoleMemento>)Can.empty()).build();
    }

    public static UserMemento ofNameAndRoles(@NonNull String name, RoleMemento ... roles) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return UserMemento.builderWithDefaults(name).roles((Can<RoleMemento>)Can.ofArray((Object[])roles)).build();
    }

    public static UserMemento ofNameAndRoleNames(@NonNull String name, String ... roleNames) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return UserMemento.ofNameAndRoleNames(name, Stream.of(roleNames));
    }

    public static UserMemento ofNameAndRoleNames(@NonNull String name, @NonNull List<String> roleNames) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (roleNames == null) {
            throw new NullPointerException("roleNames is marked non-null but is null");
        }
        return UserMemento.ofNameAndRoleNames(name, roleNames.stream());
    }

    public static UserMemento ofNameAndRoleNames(@NonNull String name, @NonNull Stream<String> roleNames) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (roleNames == null) {
            throw new NullPointerException("roleNames is marked non-null but is null");
        }
        return UserMemento.builderWithDefaults(name).roles((Can<RoleMemento>)((Can)roleNames.map(RoleMemento::new).collect(Can.toCan()))).build();
    }

    @Collection
    @CollectionLayout(sequence="1")
    public List<RoleMemento> getRoles() {
        return this.roles.toList();
    }

    @Programmatic
    public UserMemento withRoleAdded(String role) {
        return this.asBuilder().roles((Can<RoleMemento>)this.roles.add((Object)new RoleMemento(role))).build();
    }

    @Programmatic
    public boolean isCurrentUser(@Nullable String userName) {
        return this.name.equals(userName);
    }

    @Programmatic
    public Stream<String> streamRoleNames() {
        return this.roles.stream().map(RoleMemento::getName);
    }

    @Programmatic
    public boolean hasRoleName(@Nullable String roleName) {
        return this.streamRoleNames().anyMatch(myRoleName -> myRoleName.equals(roleName));
    }

    @Programmatic
    public boolean isSystem() {
        return Objects.equals(SYSTEM_USER, this);
    }

    @Programmatic
    public UserMementoBuilder asBuilder() {
        return UserMemento.builder().name(this.name).authenticationCode(this.authenticationCode).authenticationSource(this.authenticationSource).avatarUrl(this.avatarUrl).languageLocale(this.languageLocale).numberFormatLocale(this.numberFormatLocale).timeFormatLocale(this.timeFormatLocale).impersonating(this.impersonating).realName(this.realName).multiTenancyToken(this.multiTenancyToken).roles(this.roles);
    }

    @Programmatic
    public UserLocale asUserLocale() {
        Locale main = this.languageLocale != null ? this.languageLocale : Locale.getDefault();
        return UserLocale.builder().languageLocale(main).numberFormatLocale(this.numberFormatLocale != null ? this.numberFormatLocale : main).timeFormatLocale(this.timeFormatLocale != null ? this.timeFormatLocale : main).build();
    }

    private static UserMementoBuilder builderWithDefaults(String name) {
        if (_Strings.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Name not specified");
        }
        return UserMemento.builder().name(name);
    }

    private static AuthenticationSource $default$authenticationSource() {
        return AuthenticationSource.DEFAULT;
    }

    private static boolean $default$impersonating() {
        return false;
    }

    private static String $default$authenticationCode() {
        return DEFAULT_AUTH_VALID_CODE;
    }

    private static Can<RoleMemento> $default$roles() {
        return Can.empty();
    }

    UserMemento(@NonNull String name, @Nullable String realName, @Nullable URL avatarUrl, @Nullable Locale languageLocale, @Nullable Locale numberFormatLocale, @Nullable Locale timeFormatLocale, @NonNull AuthenticationSource authenticationSource, boolean impersonating, @Nullable String multiTenancyToken, @NonNull String authenticationCode, Can<RoleMemento> roles) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (authenticationSource == null) {
            throw new NullPointerException("authenticationSource is marked non-null but is null");
        }
        if (authenticationCode == null) {
            throw new NullPointerException("authenticationCode is marked non-null but is null");
        }
        this.name = name;
        this.realName = realName;
        this.avatarUrl = avatarUrl;
        this.languageLocale = languageLocale;
        this.numberFormatLocale = numberFormatLocale;
        this.timeFormatLocale = timeFormatLocale;
        this.authenticationSource = authenticationSource;
        this.impersonating = impersonating;
        this.multiTenancyToken = multiTenancyToken;
        this.authenticationCode = authenticationCode;
        this.roles = roles;
    }

    public static UserMementoBuilder builder() {
        return new UserMementoBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserMemento)) {
            return false;
        }
        UserMemento other = (UserMemento)o;
        if (this.isImpersonating() != other.isImpersonating()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$realName = this.getRealName();
        String other$realName = other.getRealName();
        if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
            return false;
        }
        URL this$avatarUrl = this.getAvatarUrl();
        URL other$avatarUrl = other.getAvatarUrl();
        if (this$avatarUrl == null ? other$avatarUrl != null : !((Object)this$avatarUrl).equals(other$avatarUrl)) {
            return false;
        }
        Locale this$languageLocale = this.getLanguageLocale();
        Locale other$languageLocale = other.getLanguageLocale();
        if (this$languageLocale == null ? other$languageLocale != null : !((Object)this$languageLocale).equals(other$languageLocale)) {
            return false;
        }
        Locale this$numberFormatLocale = this.getNumberFormatLocale();
        Locale other$numberFormatLocale = other.getNumberFormatLocale();
        if (this$numberFormatLocale == null ? other$numberFormatLocale != null : !((Object)this$numberFormatLocale).equals(other$numberFormatLocale)) {
            return false;
        }
        Locale this$timeFormatLocale = this.getTimeFormatLocale();
        Locale other$timeFormatLocale = other.getTimeFormatLocale();
        if (this$timeFormatLocale == null ? other$timeFormatLocale != null : !((Object)this$timeFormatLocale).equals(other$timeFormatLocale)) {
            return false;
        }
        AuthenticationSource this$authenticationSource = this.getAuthenticationSource();
        AuthenticationSource other$authenticationSource = other.getAuthenticationSource();
        if (this$authenticationSource == null ? other$authenticationSource != null : !((Object)((Object)this$authenticationSource)).equals((Object)other$authenticationSource)) {
            return false;
        }
        String this$multiTenancyToken = this.getMultiTenancyToken();
        String other$multiTenancyToken = other.getMultiTenancyToken();
        if (this$multiTenancyToken == null ? other$multiTenancyToken != null : !this$multiTenancyToken.equals(other$multiTenancyToken)) {
            return false;
        }
        String this$authenticationCode = this.getAuthenticationCode();
        String other$authenticationCode = other.getAuthenticationCode();
        if (this$authenticationCode == null ? other$authenticationCode != null : !this$authenticationCode.equals(other$authenticationCode)) {
            return false;
        }
        List<RoleMemento> this$roles = this.getRoles();
        List<RoleMemento> other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isImpersonating() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $realName = this.getRealName();
        result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
        URL $avatarUrl = this.getAvatarUrl();
        result = result * 59 + ($avatarUrl == null ? 43 : ((Object)$avatarUrl).hashCode());
        Locale $languageLocale = this.getLanguageLocale();
        result = result * 59 + ($languageLocale == null ? 43 : ((Object)$languageLocale).hashCode());
        Locale $numberFormatLocale = this.getNumberFormatLocale();
        result = result * 59 + ($numberFormatLocale == null ? 43 : ((Object)$numberFormatLocale).hashCode());
        Locale $timeFormatLocale = this.getTimeFormatLocale();
        result = result * 59 + ($timeFormatLocale == null ? 43 : ((Object)$timeFormatLocale).hashCode());
        AuthenticationSource $authenticationSource = this.getAuthenticationSource();
        result = result * 59 + ($authenticationSource == null ? 43 : ((Object)((Object)$authenticationSource)).hashCode());
        String $multiTenancyToken = this.getMultiTenancyToken();
        result = result * 59 + ($multiTenancyToken == null ? 43 : $multiTenancyToken.hashCode());
        String $authenticationCode = this.getAuthenticationCode();
        result = result * 59 + ($authenticationCode == null ? 43 : $authenticationCode.hashCode());
        List<RoleMemento> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        return result;
    }

    public String toString() {
        return "UserMemento(name=" + this.getName() + ", realName=" + this.getRealName() + ", avatarUrl=" + this.getAvatarUrl() + ", languageLocale=" + this.getLanguageLocale() + ", numberFormatLocale=" + this.getNumberFormatLocale() + ", timeFormatLocale=" + this.getTimeFormatLocale() + ", authenticationSource=" + this.getAuthenticationSource() + ", impersonating=" + this.isImpersonating() + ", multiTenancyToken=" + this.getMultiTenancyToken() + ", authenticationCode=" + this.getAuthenticationCode() + ", roles=" + this.getRoles() + ")";
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getRealName() {
        return this.realName;
    }

    @Programmatic
    public UserMemento withRealName(@Nullable String realName) {
        return this.realName == realName ? this : new UserMemento(this.name, realName, this.avatarUrl, this.languageLocale, this.numberFormatLocale, this.timeFormatLocale, this.authenticationSource, this.impersonating, this.multiTenancyToken, this.authenticationCode, this.roles);
    }

    @Nullable
    public URL getAvatarUrl() {
        return this.avatarUrl;
    }

    @Programmatic
    public UserMemento withAvatarUrl(@Nullable URL avatarUrl) {
        return this.avatarUrl == avatarUrl ? this : new UserMemento(this.name, this.realName, avatarUrl, this.languageLocale, this.numberFormatLocale, this.timeFormatLocale, this.authenticationSource, this.impersonating, this.multiTenancyToken, this.authenticationCode, this.roles);
    }

    @Nullable
    public Locale getLanguageLocale() {
        return this.languageLocale;
    }

    @Programmatic
    public UserMemento withLanguageLocale(@Nullable Locale languageLocale) {
        return this.languageLocale == languageLocale ? this : new UserMemento(this.name, this.realName, this.avatarUrl, languageLocale, this.numberFormatLocale, this.timeFormatLocale, this.authenticationSource, this.impersonating, this.multiTenancyToken, this.authenticationCode, this.roles);
    }

    @Nullable
    public Locale getNumberFormatLocale() {
        return this.numberFormatLocale;
    }

    @Programmatic
    public UserMemento withNumberFormatLocale(@Nullable Locale numberFormatLocale) {
        return this.numberFormatLocale == numberFormatLocale ? this : new UserMemento(this.name, this.realName, this.avatarUrl, this.languageLocale, numberFormatLocale, this.timeFormatLocale, this.authenticationSource, this.impersonating, this.multiTenancyToken, this.authenticationCode, this.roles);
    }

    @Nullable
    public Locale getTimeFormatLocale() {
        return this.timeFormatLocale;
    }

    @Programmatic
    public UserMemento withTimeFormatLocale(@Nullable Locale timeFormatLocale) {
        return this.timeFormatLocale == timeFormatLocale ? this : new UserMemento(this.name, this.realName, this.avatarUrl, this.languageLocale, this.numberFormatLocale, timeFormatLocale, this.authenticationSource, this.impersonating, this.multiTenancyToken, this.authenticationCode, this.roles);
    }

    @NonNull
    public AuthenticationSource getAuthenticationSource() {
        return this.authenticationSource;
    }

    @Programmatic
    public UserMemento withAuthenticationSource(@NonNull AuthenticationSource authenticationSource) {
        if (authenticationSource == null) {
            throw new NullPointerException("authenticationSource is marked non-null but is null");
        }
        return this.authenticationSource == authenticationSource ? this : new UserMemento(this.name, this.realName, this.avatarUrl, this.languageLocale, this.numberFormatLocale, this.timeFormatLocale, authenticationSource, this.impersonating, this.multiTenancyToken, this.authenticationCode, this.roles);
    }

    public boolean isImpersonating() {
        return this.impersonating;
    }

    @Programmatic
    public UserMemento withImpersonating(boolean impersonating) {
        return this.impersonating == impersonating ? this : new UserMemento(this.name, this.realName, this.avatarUrl, this.languageLocale, this.numberFormatLocale, this.timeFormatLocale, this.authenticationSource, impersonating, this.multiTenancyToken, this.authenticationCode, this.roles);
    }

    @Nullable
    public String getMultiTenancyToken() {
        return this.multiTenancyToken;
    }

    @Programmatic
    public UserMemento withMultiTenancyToken(@Nullable String multiTenancyToken) {
        return this.multiTenancyToken == multiTenancyToken ? this : new UserMemento(this.name, this.realName, this.avatarUrl, this.languageLocale, this.numberFormatLocale, this.timeFormatLocale, this.authenticationSource, this.impersonating, multiTenancyToken, this.authenticationCode, this.roles);
    }

    @NonNull
    public String getAuthenticationCode() {
        return this.authenticationCode;
    }

    @Programmatic
    public UserMemento withAuthenticationCode(@NonNull String authenticationCode) {
        if (authenticationCode == null) {
            throw new NullPointerException("authenticationCode is marked non-null but is null");
        }
        return this.authenticationCode == authenticationCode ? this : new UserMemento(this.name, this.realName, this.avatarUrl, this.languageLocale, this.numberFormatLocale, this.timeFormatLocale, this.authenticationSource, this.impersonating, this.multiTenancyToken, authenticationCode, this.roles);
    }

    public static class UserMementoBuilder {
        private String name;
        private String realName;
        private URL avatarUrl;
        private Locale languageLocale;
        private Locale numberFormatLocale;
        private Locale timeFormatLocale;
        private boolean authenticationSource$set;
        private AuthenticationSource authenticationSource$value;
        private boolean impersonating$set;
        private boolean impersonating$value;
        private String multiTenancyToken;
        private boolean authenticationCode$set;
        private String authenticationCode$value;
        private boolean roles$set;
        private Can<RoleMemento> roles$value;

        UserMementoBuilder() {
        }

        public UserMementoBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public UserMementoBuilder realName(@Nullable String realName) {
            this.realName = realName;
            return this;
        }

        public UserMementoBuilder avatarUrl(@Nullable URL avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        public UserMementoBuilder languageLocale(@Nullable Locale languageLocale) {
            this.languageLocale = languageLocale;
            return this;
        }

        public UserMementoBuilder numberFormatLocale(@Nullable Locale numberFormatLocale) {
            this.numberFormatLocale = numberFormatLocale;
            return this;
        }

        public UserMementoBuilder timeFormatLocale(@Nullable Locale timeFormatLocale) {
            this.timeFormatLocale = timeFormatLocale;
            return this;
        }

        public UserMementoBuilder authenticationSource(@NonNull AuthenticationSource authenticationSource) {
            if (authenticationSource == null) {
                throw new NullPointerException("authenticationSource is marked non-null but is null");
            }
            this.authenticationSource$value = authenticationSource;
            this.authenticationSource$set = true;
            return this;
        }

        public UserMementoBuilder impersonating(boolean impersonating) {
            this.impersonating$value = impersonating;
            this.impersonating$set = true;
            return this;
        }

        public UserMementoBuilder multiTenancyToken(@Nullable String multiTenancyToken) {
            this.multiTenancyToken = multiTenancyToken;
            return this;
        }

        public UserMementoBuilder authenticationCode(@NonNull String authenticationCode) {
            if (authenticationCode == null) {
                throw new NullPointerException("authenticationCode is marked non-null but is null");
            }
            this.authenticationCode$value = authenticationCode;
            this.authenticationCode$set = true;
            return this;
        }

        public UserMementoBuilder roles(Can<RoleMemento> roles) {
            this.roles$value = roles;
            this.roles$set = true;
            return this;
        }

        public UserMemento build() {
            AuthenticationSource authenticationSource$value = this.authenticationSource$value;
            if (!this.authenticationSource$set) {
                authenticationSource$value = UserMemento.$default$authenticationSource();
            }
            boolean impersonating$value = this.impersonating$value;
            if (!this.impersonating$set) {
                impersonating$value = UserMemento.$default$impersonating();
            }
            String authenticationCode$value = this.authenticationCode$value;
            if (!this.authenticationCode$set) {
                authenticationCode$value = UserMemento.$default$authenticationCode();
            }
            Can<RoleMemento> roles$value = this.roles$value;
            if (!this.roles$set) {
                roles$value = UserMemento.$default$roles();
            }
            return new UserMemento(this.name, this.realName, this.avatarUrl, this.languageLocale, this.numberFormatLocale, this.timeFormatLocale, authenticationSource$value, impersonating$value, this.multiTenancyToken, authenticationCode$value, roles$value);
        }

        public String toString() {
            return "UserMemento.UserMementoBuilder(name=" + this.name + ", realName=" + this.realName + ", avatarUrl=" + this.avatarUrl + ", languageLocale=" + this.languageLocale + ", numberFormatLocale=" + this.numberFormatLocale + ", timeFormatLocale=" + this.timeFormatLocale + ", authenticationSource$value=" + this.authenticationSource$value + ", impersonating$value=" + this.impersonating$value + ", multiTenancyToken=" + this.multiTenancyToken + ", authenticationCode$value=" + this.authenticationCode$value + ", roles$value=" + this.roles$value + ")";
        }
    }

    public static enum AuthenticationSource {
        DEFAULT,
        EXTERNAL;


        public boolean isExternal() {
            return this == EXTERNAL;
        }
    }

    public static class UiSubscriber {
        @Order(value=0x5FFFFFFF)
        @EventListener(value={TitleUiEvent.class})
        public void on(TitleUiEvent ev) {
            UserMemento userMemento = (UserMemento)ev.getSource();
            assert (userMemento != null);
            String title = String.format("%s %s", userMemento.getName(), userMemento.isImpersonating() ? " (impersonating)" : UserMemento.DEFAULT_AUTH_VALID_CODE);
            ev.setTitle(title);
        }
    }

    public static class TitleUiEvent
    extends IsisModuleApplib.TitleUiEvent<UserMemento> {
    }
}

