/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.user;

import java.io.Serializable;
import javax.inject.Named;
import lombok.NonNull;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Named(value="isis.applib.RoleMemento")
@DomainObject(nature=Nature.VIEW_MODEL)
@DomainObjectLayout(titleUiEvent=TitleUiEvent.class)
public final class RoleMemento
implements Serializable {
    static final String LOGICAL_TYPE_NAME = "isis.applib.RoleMemento";
    private static final long serialVersionUID = -3876856609238378274L;
    @PropertyLayout(fieldSetId="identity", sequence="1")
    private final String name;
    @PropertyLayout(fieldSetId="details", sequence="1")
    private final String description;

    public RoleMemento(String name) {
        this(name, "");
    }

    public RoleMemento(@NonNull String name, @NonNull String description) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.name = name;
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoleMemento)) {
            return false;
        }
        RoleMemento other = (RoleMemento)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "RoleMemento(name=" + this.getName() + ", description=" + this.getDescription() + ")";
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static class UiSubscriber {
        @Order(value=0x5FFFFFFF)
        @EventListener(value={TitleUiEvent.class})
        public void on(TitleUiEvent ev) {
            RoleMemento roleMemento = (RoleMemento)ev.getSource();
            assert (roleMemento != null);
            ev.setTitle(roleMemento.getName());
        }
    }

    public static class TitleUiEvent
    extends IsisModuleApplib.TitleUiEvent<RoleMemento> {
    }
}

