/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.user;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.Redirect;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.applib.services.user.UserService;

@DomainService(nature=NatureOfService.VIEW)
@Named(value="isis.applib.ImpersonateStopMenu")
@DomainServiceLayout(named="Security", menuBar=DomainServiceLayout.MenuBar.TERTIARY)
@Priority(value=0x1FFFFFFF)
public class ImpersonateStopMenu {
    static final String LOGICAL_TYPE_NAME = "isis.applib.ImpersonateStopMenu";
    final UserService userService;
    final MessageService messageService;

    private boolean isImpersonating() {
        return this.userService.supportsImpersonation() && this.userService.isImpersonating();
    }

    @Inject
    public ImpersonateStopMenu(UserService userService, MessageService messageService) {
        this.userService = userService;
        this.messageService = messageService;
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.IDEMPOTENT, commandPublishing=Publishing.DISABLED, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(sequence="100.3", redirectPolicy=Redirect.EVEN_IF_SAME)
    public class stopImpersonating {
        @MemberSupport
        public void act() {
            ImpersonateStopMenu.this.userService.stopImpersonating();
            ImpersonateStopMenu.this.messageService.informUser("No longer impersonating another user");
        }

        @MemberSupport
        public boolean hideAct() {
            return !ImpersonateStopMenu.this.isImpersonating();
        }

        public class ActionDomainEvent
        extends org.apache.isis.applib.services.user.ImpersonateStopMenu$ActionDomainEvent<stopImpersonating> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends IsisModuleApplib.ActionDomainEvent<T> {
    }
}

