/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.applib.services.user.ImpersonateMenuAdvisor;
import org.apache.isis.applib.services.user.UserService;

@DomainService(nature=NatureOfService.VIEW)
@Named(value="isis.sudo.ImpersonateMenu")
@DomainServiceLayout(named="Security", menuBar=DomainServiceLayout.MenuBar.TERTIARY)
@Priority(value=0x1FFFFFFF)
public class ImpersonateMenu {
    public static final String LOGICAL_TYPE_NAME = "isis.sudo.ImpersonateMenu";
    final UserService userService;
    final MessageService messageService;
    final FactoryService factoryService;
    final List<ImpersonateMenuAdvisor> impersonateMenuAdvisors;

    private ImpersonateMenuAdvisor impersonateMenuAdvisor() {
        return this.impersonateMenuAdvisors.get(0);
    }

    @Inject
    public ImpersonateMenu(UserService userService, MessageService messageService, FactoryService factoryService, List<ImpersonateMenuAdvisor> impersonateMenuAdvisors) {
        this.userService = userService;
        this.messageService = messageService;
        this.factoryService = factoryService;
        this.impersonateMenuAdvisors = impersonateMenuAdvisors;
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.IDEMPOTENT, commandPublishing=Publishing.DISABLED, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(sequence="100.2", cssClassFa="fa-mask")
    public class impersonateWithRoles {
        @MemberSupport
        public void act(String userName, List<String> roleNames, String multiTenancyToken) {
            ArrayList<String> roleNamesCopy = new ArrayList<String>(roleNames);
            if (!roleNamesCopy.contains("org.apache.isis.security.AUTHORIZED_USER_ROLE")) {
                roleNamesCopy.add("org.apache.isis.security.AUTHORIZED_USER_ROLE");
            }
            ImpersonateMenu.this.userService.impersonateUser(userName, roleNamesCopy, multiTenancyToken);
            ImpersonateMenu.this.messageService.informUser("Now impersonating " + userName);
        }

        @MemberSupport
        public boolean hideAct() {
            return !ImpersonateMenu.this.userService.supportsImpersonation() || this.choices0Act().isEmpty();
        }

        @MemberSupport
        public String disableAct() {
            return ImpersonateMenu.this.userService.isImpersonating() ? "currently impersonating" : null;
        }

        @MemberSupport
        public List<String> choices0Act() {
            return ImpersonateMenu.this.impersonateMenuAdvisor().allUserNames();
        }

        @MemberSupport
        public List<String> choices1Act(String userName) {
            return ImpersonateMenu.this.impersonateMenuAdvisor().allRoleNames();
        }

        @MemberSupport
        public List<String> default1Act(String userName) {
            return ImpersonateMenu.this.impersonateMenuAdvisor().roleNamesFor(userName);
        }

        @MemberSupport
        public String default2Act(String userName, List<String> roleNames) {
            return ImpersonateMenu.this.impersonateMenuAdvisor().multiTenancyTokenFor(userName);
        }

        public class ActionDomainEvent
        extends org.apache.isis.applib.services.user.ImpersonateMenu$ActionDomainEvent<impersonateWithRoles> {
        }
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.IDEMPOTENT, commandPublishing=Publishing.DISABLED, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(sequence="100.1", cssClassFa="fa-mask")
    public class impersonate {
        @MemberSupport
        public void act(String userName) {
            ImpersonateMenu.this.userService.impersonateUser(userName, Collections.singletonList("org.apache.isis.security.AUTHORIZED_USER_ROLE"), null);
            ImpersonateMenu.this.messageService.informUser("Now impersonating " + userName);
        }

        @MemberSupport
        public boolean hideAct() {
            return !ImpersonateMenu.this.userService.supportsImpersonation() || !ImpersonateMenu.this.factoryService.mixin(impersonateWithRoles.class, ImpersonateMenu.this).hideAct();
        }

        @MemberSupport
        public String disableAct() {
            return ImpersonateMenu.this.userService.isImpersonating() ? "currently impersonating" : null;
        }

        public class ActionDomainEvent
        extends org.apache.isis.applib.services.user.ImpersonateMenu$ActionDomainEvent<ActionDomainEvent> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends IsisModuleApplib.ActionDomainEvent<T> {
    }
}

