/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.urlencoding;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.memento._Mementos;

public interface UrlEncodingService
extends _Mementos.EncoderDecoder {
    public String encode(byte[] var1);

    public byte[] decode(String var1);

    default public String encodeString(String str) {
        return this.encode(_Strings.toBytes((String)str, (Charset)StandardCharsets.UTF_8));
    }

    default public String decodeToString(String str) {
        return _Strings.ofBytes((byte[])this.decode(str), (Charset)StandardCharsets.UTF_8);
    }

    public static UrlEncodingService forTesting() {
        return new UrlEncodingService(){

            @Override
            public String encode(byte[] bytes) {
                return _Strings.ofBytes((byte[])_Bytes.asCompressedUrlBase64.apply(bytes), (Charset)StandardCharsets.UTF_8);
            }

            @Override
            public byte[] decode(String str) {
                return _Bytes.ofCompressedUrlBase64.apply(_Strings.toBytes((String)str, (Charset)StandardCharsets.UTF_8));
            }
        };
    }

    public static UrlEncodingService forTestingNoCompression() {
        return new UrlEncodingService(){

            @Override
            public String encode(byte[] bytes) {
                return _Strings.ofBytes((byte[])_Bytes.asUrlBase64.apply(bytes), (Charset)StandardCharsets.UTF_8);
            }

            @Override
            public byte[] decode(String str) {
                return _Bytes.ofUrlBase64.apply(_Strings.toBytes((String)str, (Charset)StandardCharsets.UTF_8));
            }
        };
    }
}

