/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.sudo;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.UnaryOperator;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.NonNull;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.applib.services.iactnlayer.InteractionLayer;
import org.apache.isis.applib.services.iactnlayer.InteractionLayerTracker;
import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.applib.services.sudo.SudoServiceListener;
import org.apache.isis.applib.services.user.RoleMemento;
import org.apache.isis.commons.functional.ThrowingRunnable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.applib.SudoService")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class SudoService {
    static final String LOGICAL_TYPE_NAME = "isis.applib.SudoService";
    public static RoleMemento ACCESS_ALL_ROLE = new RoleMemento(SudoService.class.getName() + "#accessAll", "Sudo, can view and use all object members.");
    private final InteractionService interactionService;
    private final InteractionLayerTracker interactionLayerTracker;
    private final List<SudoServiceListener> sudoListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(@NonNull UnaryOperator<InteractionContext> sudoMapper, @NonNull Callable<T> callable) {
        if (sudoMapper == null) {
            throw new NullPointerException("sudoMapper is marked non-null but is null");
        }
        if (callable == null) {
            throw new NullPointerException("callable is marked non-null but is null");
        }
        InteractionLayer currentInteractionLayer = this.interactionLayerTracker.currentInteractionLayerElseFail();
        InteractionContext currentInteractionContext = currentInteractionLayer.getInteractionContext();
        InteractionContext sudoInteractionContext = (InteractionContext)sudoMapper.apply(currentInteractionContext);
        try {
            for (SudoServiceListener sudoListener : this.sudoListeners) {
                sudoListener.beforeCall(currentInteractionContext, sudoInteractionContext);
            }
            Iterator<SudoServiceListener> iterator = this.interactionService.call(sudoInteractionContext, callable);
            return (T)iterator;
        }
        finally {
            for (SudoServiceListener sudoListener : this.sudoListeners) {
                sudoListener.afterCall(sudoInteractionContext, currentInteractionContext);
            }
        }
    }

    public void run(@NonNull UnaryOperator<InteractionContext> sudoMapper, @NonNull ThrowingRunnable runnable) {
        if (sudoMapper == null) {
            throw new NullPointerException("sudoMapper is marked non-null but is null");
        }
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        this.call(sudoMapper, ThrowingRunnable.toCallable((ThrowingRunnable)runnable));
    }

    @Inject
    public SudoService(InteractionService interactionService, InteractionLayerTracker interactionLayerTracker, List<SudoServiceListener> sudoListeners) {
        this.interactionService = interactionService;
        this.interactionLayerTracker = interactionLayerTracker;
        this.sudoListeners = sudoListeners;
    }
}

