/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.sitemap;

import javax.annotation.Priority;
import javax.inject.Named;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.sitemap.SitemapService;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.commons.internal.base._Strings;

@Named(value="isis.applib.SitemapServiceMenu")
@DomainService
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Priority(value=0x1FFFFFFF)
public class SitemapServiceMenu {
    public static final String LOGICAL_TYPE_NAME = "isis.applib.SitemapServiceMenu";
    private final SitemapService sitemapService;

    public SitemapServiceMenu(SitemapService sitemapService) {
        this.sitemapService = sitemapService;
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.NON_IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Site-Map Template (Adoc)", sequence="500.450.1")
    public class downloadSitemap {
        @MemberSupport
        public Clob act(@Parameter(optionality=Optionality.MANDATORY) String title, @Parameter(optionality=Optionality.MANDATORY) String fileName) {
            String adoc = SitemapServiceMenu.this.sitemapService.toSitemapAdoc(title);
            return new Clob(_Strings.asFileNameWithExtension((String)fileName, (String)".adoc"), "text/plain", (CharSequence)adoc);
        }

        @MemberSupport
        public String default0Act() {
            return "Site-Map";
        }

        @MemberSupport
        public String default1Act() {
            return "sitemap.adoc";
        }

        public class ActionDomainEvent
        extends org.apache.isis.applib.services.sitemap.SitemapServiceMenu$ActionDomainEvent<downloadSitemap> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends IsisModuleApplib.ActionDomainEvent<T> {
    }
}

