/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.session;

import java.util.Date;
import java.util.UUID;
import javax.annotation.Priority;
import javax.inject.Named;
import org.apache.isis.applib.services.session.SessionSubscriber;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.applib.SessionLogger")
@Priority(value=0x5FFFFFFF)
@Qualifier(value="logging")
public class SessionLogger
implements SessionSubscriber {
    private static final Logger log = LogManager.getLogger(SessionLogger.class);
    static final String LOGICAL_TYPE_NAME = "isis.applib.SessionLogger";

    @Override
    public void log(SessionSubscriber.Type type, String username, Date date, SessionSubscriber.CausedBy causedBy, UUID sessionGuid, String httpSessionId) {
        if (log.isDebugEnabled()) {
            String msg = String.format("User '%s' with sessionGuid '%s' (httpSessionId '%s') has logged %s at '%s'.%s", username, sessionGuid, httpSessionId, type == SessionSubscriber.Type.LOGIN ? "in" : "out", date, causedBy == SessionSubscriber.CausedBy.SESSION_EXPIRATION ? " (session expiration)" : "");
            log.debug(msg);
        }
    }
}

