/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.repository;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.NonNull;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.services.repository.EntityState;
import org.springframework.lang.Nullable;

public interface RepositoryService {
    public EntityState getEntityState(@Nullable Object var1);

    public <T> T detachedEntity(@NonNull T var1);

    public <T> T persist(T var1);

    public <T> T persistAndFlush(T var1);

    default public void persistAndFlush(Object ... domainObjects) {
        int length = domainObjects.length;
        for (int i = 0; i < length; ++i) {
            Object domainObject = domainObjects[i];
            if (i < length - 1) {
                this.persist(domainObject);
                continue;
            }
            this.persistAndFlush((T)domainObject);
        }
    }

    public void remove(Object var1);

    public void removeAndFlush(Object var1);

    public <T> void removeAll(Class<T> var1);

    public <T> List<T> allInstances(Class<T> var1);

    public <T> List<T> allInstances(Class<T> var1, long var2, long var4);

    public <T> List<T> allMatches(Class<T> var1, Predicate<? super T> var2);

    public <T> List<T> allMatches(Class<T> var1, Predicate<? super T> var2, long var3, long var5);

    public <T> List<T> allMatches(Query<T> var1);

    public <T> Optional<T> uniqueMatch(Class<T> var1, Predicate<T> var2);

    public <T> Optional<T> uniqueMatch(Query<T> var1);

    public <T> Optional<T> firstMatch(Class<T> var1, Predicate<T> var2);

    public <T> Optional<T> firstMatch(Query<T> var1);

    public <T> T refresh(T var1);

    public <T> T detach(T var1);
}

