/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.repository;

public enum EntityState {
    NOT_PERSISTABLE,
    PERSISTABLE_ATTACHED,
    PERSISTABLE_DETACHED,
    PERSISTABLE_REMOVED,
    PERSISTABLE_ATTACHED_NO_OID,
    PERSISTABLE_DETACHED_WITH_OID;


    public boolean isPersistable() {
        return this != NOT_PERSISTABLE;
    }

    public boolean isAttached() {
        return this == PERSISTABLE_ATTACHED;
    }

    public boolean isDetached() {
        return this == PERSISTABLE_DETACHED;
    }

    public boolean isRemoved() {
        return this == PERSISTABLE_REMOVED;
    }

    public boolean isAttachedNoOid() {
        return this == PERSISTABLE_ATTACHED_NO_OID;
    }

    public boolean isDetachedCannotReattach() {
        return (this.isDetached() || this.isRemoved()) && !this.isSpecicalJpaDetachedWithOid();
    }

    @Deprecated
    public boolean isAttachedOrRemoved() {
        return this.isAttached() || this.isRemoved();
    }

    public boolean isSpecicalJpaDetachedWithOid() {
        return this == PERSISTABLE_DETACHED_WITH_OID;
    }

    public boolean hasOid() {
        return this.isAttached() || this.isSpecicalJpaDetachedWithOid();
    }
}

