/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.registry;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.applib.services.registry.InstanceByPriorityComparator;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal._Constants;
import org.apache.isis.commons.internal.base._Reduction;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.commons.internal.ioc._ManagedBeanAdapter;

public interface ServiceRegistry {
    public <T> Can<T> select(Class<T> var1, Annotation[] var2);

    default public <T> Can<T> select(Class<T> type) {
        return this.select(type, _Constants.emptyAnnotations);
    }

    default public Stream<_ManagedBeanAdapter> streamRegisteredBeansOfType(Class<?> requiredType) {
        return this.streamRegisteredBeans().filter(beanAdapter -> beanAdapter.isCandidateFor(requiredType));
    }

    public Stream<_ManagedBeanAdapter> streamRegisteredBeans();

    public Optional<_ManagedBeanAdapter> lookupRegisteredBeanById(LogicalType var1);

    default public _ManagedBeanAdapter lookupRegisteredBeanByIdElseFail(LogicalType id) {
        return this.lookupRegisteredBeanById(id).orElseThrow(() -> _Exceptions.unrecoverable((String)("Failed to lookup BeanAdapter by id '" + id + "'")));
    }

    public Optional<?> lookupBeanById(String var1);

    default public <T> Optional<T> lookupService(Class<T> serviceClass) {
        InstanceByPriorityComparator comparator = InstanceByPriorityComparator.instance();
        return this.lookupService(serviceClass, comparator);
    }

    default public <T> Optional<T> lookupService(Class<T> serviceClass, Comparator<Object> comparator) {
        Can<T> bin = this.select(serviceClass);
        if (bin.isEmpty()) {
            return Optional.empty();
        }
        if (bin.isCardinalityOne()) {
            return bin.getSingleton();
        }
        _Reduction toComparatorReduction = _Reduction.of((max, next) -> {
            boolean b = comparator.compare(next, max) > 0;
            return b ? next : max;
        });
        bin.forEach((Consumer)toComparatorReduction);
        return toComparatorReduction.getResult();
    }

    default public <T> T lookupServiceElseFail(Class<T> serviceClass) {
        return this.lookupService(serviceClass).orElseThrow(() -> new NoSuchElementException("Could not locate service of type '" + serviceClass + "'"));
    }

    public void clearRegisteredBeans();
}

