/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.registry;

import java.util.Comparator;
import javax.annotation.Priority;
import org.apache.isis.commons.internal.reflection._Reflect;
import org.springframework.context.annotation.Primary;

public class InstanceByPriorityComparator
implements Comparator<Object> {
    private static final InstanceByPriorityComparator INSTANCE = new InstanceByPriorityComparator();

    public static InstanceByPriorityComparator instance() {
        return INSTANCE;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Primary primaryAnnot1 = (Primary)_Reflect.getAnnotation(o1.getClass(), Primary.class);
        Primary primaryAnnot2 = (Primary)_Reflect.getAnnotation(o2.getClass(), Primary.class);
        if (primaryAnnot1 != null && primaryAnnot2 == null) {
            return 1;
        }
        if (primaryAnnot1 == null && primaryAnnot2 != null) {
            return -1;
        }
        Priority prioAnnot1 = (Priority)_Reflect.getAnnotation(o1.getClass(), Priority.class);
        Priority prioAnnot2 = (Priority)_Reflect.getAnnotation(o2.getClass(), Priority.class);
        int prio1 = prioAnnot1 != null ? prioAnnot1.value() : Integer.MAX_VALUE;
        int prio2 = prioAnnot2 != null ? prioAnnot2.value() : Integer.MAX_VALUE;
        return Integer.compare(prio2, prio1);
    }
}

